/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.driver;

import cubrid.jdbc.driver.CUBRIDConnectionPoolDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;

class CUBRIDConnectionEventListener
implements ConnectionEventListener {
    private Vector<PooledConnection> availableConnections = new Vector();
    private CUBRIDConnectionPoolDataSource cpds;

    CUBRIDConnectionEventListener(CUBRIDConnectionPoolDataSource ds) {
        this.cpds = ds;
    }

    public synchronized void connectionClosed(ConnectionEvent event) {
        PooledConnection pc = (PooledConnection)event.getSource();
        if (pc == null) {
            return;
        }
        this.availableConnections.add(pc);
    }

    public void connectionErrorOccurred(ConnectionEvent event) {
        PooledConnection pc = (PooledConnection)event.getSource();
        if (pc == null) {
            return;
        }
        try {
            pc.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    synchronized Connection getConnection(String user, String passwd) throws SQLException {
        PooledConnection pc;
        if (this.availableConnections.size() <= 0) {
            pc = this.cpds.getPooledConnection(user, passwd);
            pc.addConnectionEventListener(this);
            this.availableConnections.add(pc);
        }
        pc = this.availableConnections.remove(0);
        return pc.getConnection();
    }
}

