/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.driver;

import cubrid.jdbc.driver.CUBRIDConnection;
import cubrid.jdbc.driver.CUBRIDConnectionPoolDataSource;
import cubrid.jdbc.driver.CUBRIDConnectionPoolManager;
import cubrid.jdbc.driver.CUBRIDDataSourceBase;
import cubrid.jdbc.driver.CUBRIDDriver;
import cubrid.jdbc.jci.UConnection;
import cubrid.jdbc.jci.UJCIManager;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.sql.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CUBRIDDataSource
extends CUBRIDDataSourceBase
implements DataSource,
Referenceable,
Serializable {
    private static final long serialVersionUID = -1038542340147556509L;

    public CUBRIDDataSource() {
    }

    protected CUBRIDDataSource(Reference ref) {
        this.setProperties(ref);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(null, null);
    }

    @Override
    public Connection getConnection(String username, String passwd) throws SQLException {
        Connection con;
        String dataSourceName = this.getDataSourceName();
        if (dataSourceName == null || dataSourceName.length() == 0) {
            if (this.getUrl() != null) {
                CUBRIDDriver driver = new CUBRIDDriver();
                Properties props = new Properties();
                if (username != null) {
                    props.setProperty("user", username);
                }
                if (passwd != null) {
                    props.setProperty("password", passwd);
                }
                con = driver.connect(this.getUrl(), props);
            } else {
                if (username == null) {
                    username = this.getUser();
                }
                if (passwd == null) {
                    passwd = this.getPassword();
                }
                UConnection u_con = UJCIManager.connect(this.getServerName(), this.getPortNumber(), this.getDatabaseName(), username, passwd, this.getDataSourceID(username));
                con = new CUBRIDConnection(u_con, null, username);
            }
            this.writeLog("getConnection(" + username + ")");
        } else {
            CUBRIDConnectionPoolDataSource cpds = CUBRIDConnectionPoolManager.getConnectionPoolDataSource(dataSourceName);
            if (username == null) {
                username = cpds.getUser();
            }
            if (passwd == null) {
                passwd = cpds.getPassword();
            }
            con = CUBRIDConnectionPoolManager.getConnection(cpds, username, passwd);
        }
        return con;
    }

    @Override
    public synchronized Reference getReference() throws NamingException {
        Reference ref = new Reference(this.getClass().getName(), "cubrid.jdbc.driver.CUBRIDDataSourceObjectFactory", null);
        ref = this.getProperties(ref);
        this.writeLog("Bind DataSource");
        return ref;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Logger getParentLogger() {
        throw new UnsupportedOperationException();
    }
}

