/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.driver;

import cubrid.jdbc.driver.CUBRIDException;
import cubrid.jdbc.driver.CUBRIDInputStream;
import cubrid.jdbc.driver.CUBRIDJDBCErrorCode;
import cubrid.jdbc.driver.CUBRIDResultSetMetaData;
import cubrid.jdbc.jci.UGetTypeConvertedValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CUBRIDResultSetWithoutQuery
implements ResultSet {
    int[] type;
    int[] precision;
    boolean[] nullable;
    String[] column_name;
    private int num_of_columns;
    private int num_of_rows;
    private int current_row;
    private boolean was_null;
    private boolean is_closed;
    private ArrayList<Object[]> rows;
    private CUBRIDResultSetMetaData meta_data;
    private ArrayList<InputStream> streams;
    private int fetch_size;

    protected CUBRIDResultSetWithoutQuery(int columns, int[] types, String[] colnames, boolean[] isnull, int[] precision) {
        if (precision == null) {
            precision = new int[columns];
            Arrays.fill(precision, 0);
        }
        this.initialize(columns, types, colnames, isnull, precision);
    }

    private void initialize(int columns, int[] types, String[] colnames, boolean[] isnull, int[] precision) {
        this.num_of_columns = columns;
        this.type = types;
        this.precision = precision;
        this.nullable = isnull;
        this.column_name = colnames;
        this.current_row = -1;
        this.num_of_rows = 0;
        this.was_null = false;
        this.is_closed = false;
        this.rows = new ArrayList(10);
        this.meta_data = null;
        this.streams = new ArrayList();
        this.fetch_size = 0;
    }

    @Override
    public synchronized boolean next() throws SQLException {
        this.checkIsOpen();
        this.clearAllStreams();
        ++this.current_row;
        if (this.current_row == this.num_of_rows) {
            this.close();
            return false;
        }
        return true;
    }

    @Override
    public synchronized void close() throws SQLException {
        if (this.is_closed) {
            return;
        }
        this.is_closed = true;
        this.clearAllStreams();
        this.type = null;
        this.precision = null;
        this.column_name = null;
        this.rows.clear();
        this.rows = null;
        this.meta_data = null;
    }

    @Override
    public synchronized boolean wasNull() throws SQLException {
        this.checkIsOpen();
        return this.was_null;
    }

    @Override
    public synchronized String getString(int columnIndex) throws SQLException {
        this.checkIsOpen();
        this.beforeGetValue(columnIndex);
        try {
            return UGetTypeConvertedValue.getString(this.rows.get(this.current_row)[columnIndex - 1]);
        }
        catch (Exception e) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.conversion_error);
        }
    }

    @Override
    public synchronized boolean getBoolean(int columnIndex) throws SQLException {
        this.checkIsOpen();
        this.beforeGetValue(columnIndex);
        try {
            return UGetTypeConvertedValue.getBoolean(this.rows.get(this.current_row)[columnIndex - 1]);
        }
        catch (Exception e) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.conversion_error);
        }
    }

    @Override
    public synchronized byte getByte(int columnIndex) throws SQLException {
        this.checkIsOpen();
        this.beforeGetValue(columnIndex);
        try {
            return UGetTypeConvertedValue.getByte(this.rows.get(this.current_row)[columnIndex - 1]);
        }
        catch (Exception e) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.conversion_error);
        }
    }

    @Override
    public synchronized short getShort(int columnIndex) throws SQLException {
        this.checkIsOpen();
        this.beforeGetValue(columnIndex);
        try {
            return UGetTypeConvertedValue.getShort(this.rows.get(this.current_row)[columnIndex - 1]);
        }
        catch (Exception e) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.conversion_error);
        }
    }

    @Override
    public synchronized int getInt(int columnIndex) throws SQLException {
        this.checkIsOpen();
        this.beforeGetValue(columnIndex);
        try {
            return UGetTypeConvertedValue.getInt(this.rows.get(this.current_row)[columnIndex - 1]);
        }
        catch (Exception e) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.conversion_error);
        }
    }

    @Override
    public synchronized long getLong(int columnIndex) throws SQLException {
        this.checkIsOpen();
        this.beforeGetValue(columnIndex);
        try {
            return UGetTypeConvertedValue.getLong(this.rows.get(this.current_row)[columnIndex - 1]);
        }
        catch (Exception e) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.conversion_error);
        }
    }

    @Override
    public synchronized float getFloat(int columnIndex) throws SQLException {
        this.checkIsOpen();
        this.beforeGetValue(columnIndex);
        try {
            return UGetTypeConvertedValue.getFloat(this.rows.get(this.current_row)[columnIndex - 1]);
        }
        catch (Exception e) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.conversion_error);
        }
    }

    @Override
    public synchronized double getDouble(int columnIndex) throws SQLException {
        this.checkIsOpen();
        this.beforeGetValue(columnIndex);
        try {
            return UGetTypeConvertedValue.getDouble(this.rows.get(this.current_row)[columnIndex - 1]);
        }
        catch (Exception e) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.conversion_error);
        }
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized byte[] getBytes(int columnIndex) throws SQLException {
        this.checkIsOpen();
        this.beforeGetValue(columnIndex);
        try {
            return UGetTypeConvertedValue.getBytes(this.rows.get(this.current_row)[columnIndex - 1]);
        }
        catch (Exception e) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.conversion_error);
        }
    }

    @Override
    public synchronized Date getDate(int columnIndex) throws SQLException {
        this.checkIsOpen();
        this.beforeGetValue(columnIndex);
        try {
            return UGetTypeConvertedValue.getDate(this.rows.get(this.current_row)[columnIndex - 1]);
        }
        catch (Exception e) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.conversion_error);
        }
    }

    @Override
    public synchronized Time getTime(int columnIndex) throws SQLException {
        this.checkIsOpen();
        this.beforeGetValue(columnIndex);
        try {
            return UGetTypeConvertedValue.getTime(this.rows.get(this.current_row)[columnIndex - 1]);
        }
        catch (Exception e) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.conversion_error);
        }
    }

    @Override
    public synchronized Timestamp getTimestamp(int columnIndex) throws SQLException {
        this.checkIsOpen();
        this.beforeGetValue(columnIndex);
        try {
            return UGetTypeConvertedValue.getTimestamp(this.rows.get(this.current_row)[columnIndex - 1]);
        }
        catch (Exception e) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.conversion_error);
        }
    }

    @Override
    public synchronized InputStream getAsciiStream(int columnIndex) throws SQLException {
        this.checkIsOpen();
        String str = this.getString(columnIndex);
        if (str == null) {
            return null;
        }
        CUBRIDInputStream stream = new CUBRIDInputStream(str.getBytes());
        this.addStream(stream);
        return stream;
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized InputStream getBinaryStream(int columnIndex) throws SQLException {
        this.checkIsOpen();
        byte[] b = this.getBytes(columnIndex);
        if (b == null) {
            return null;
        }
        CUBRIDInputStream stream = new CUBRIDInputStream(b);
        this.addStream(stream);
        return stream;
    }

    @Override
    public synchronized String getString(String columnName) throws SQLException {
        return this.getString(this.findColumn(columnName));
    }

    @Override
    public synchronized boolean getBoolean(String columnName) throws SQLException {
        return this.getBoolean(this.findColumn(columnName));
    }

    @Override
    public synchronized byte getByte(String columnName) throws SQLException {
        return this.getByte(this.findColumn(columnName));
    }

    @Override
    public synchronized short getShort(String columnName) throws SQLException {
        return this.getShort(this.findColumn(columnName));
    }

    @Override
    public synchronized int getInt(String columnName) throws SQLException {
        return this.getInt(this.findColumn(columnName));
    }

    @Override
    public synchronized long getLong(String columnName) throws SQLException {
        return this.getLong(this.findColumn(columnName));
    }

    @Override
    public synchronized float getFloat(String columnName) throws SQLException {
        return this.getFloat(this.findColumn(columnName));
    }

    @Override
    public synchronized double getDouble(String columnName) throws SQLException {
        return this.getDouble(this.findColumn(columnName));
    }

    @Override
    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized byte[] getBytes(String columnName) throws SQLException {
        return this.getBytes(this.findColumn(columnName));
    }

    @Override
    public synchronized Date getDate(String columnName) throws SQLException {
        return this.getDate(this.findColumn(columnName));
    }

    @Override
    public synchronized Time getTime(String columnName) throws SQLException {
        return this.getTime(this.findColumn(columnName));
    }

    @Override
    public synchronized Timestamp getTimestamp(String columnName) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName));
    }

    @Override
    public synchronized InputStream getAsciiStream(String columnName) throws SQLException {
        return this.getAsciiStream(this.findColumn(columnName));
    }

    @Override
    public InputStream getUnicodeStream(String columnName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized InputStream getBinaryStream(String columnName) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnName));
    }

    @Override
    public synchronized SQLWarning getWarnings() throws SQLException {
        this.checkIsOpen();
        return null;
    }

    @Override
    public synchronized void clearWarnings() throws SQLException {
        this.checkIsOpen();
    }

    @Override
    public String getCursorName() throws SQLException {
        throw new CUBRIDException(CUBRIDJDBCErrorCode.not_supported);
    }

    @Override
    public synchronized ResultSetMetaData getMetaData() throws SQLException {
        this.checkIsOpen();
        if (this.meta_data == null) {
            this.meta_data = new CUBRIDResultSetMetaData(this);
        }
        return this.meta_data;
    }

    @Override
    public synchronized Object getObject(int columnIndex) throws SQLException {
        this.checkIsOpen();
        this.beforeGetValue(columnIndex);
        return this.rows.get(this.current_row)[columnIndex - 1];
    }

    @Override
    public synchronized Object getObject(String columnName) throws SQLException {
        return this.getObject(this.findColumn(columnName));
    }

    @Override
    public synchronized int findColumn(String columnName) throws SQLException {
        this.checkIsOpen();
        if (columnName == null) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < this.column_name.length; ++i) {
            if (!this.column_name[i].equalsIgnoreCase(columnName)) continue;
            return i + 1;
        }
        throw new CUBRIDException(CUBRIDJDBCErrorCode.invalid_column_name);
    }

    @Override
    public synchronized Reader getCharacterStream(int columnIndex) throws SQLException {
        this.checkIsOpen();
        throw new UnsupportedOperationException("Method getCharacterStream() not yet implemented.");
    }

    @Override
    public synchronized Reader getCharacterStream(String columnName) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnName));
    }

    @Override
    public synchronized BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        this.checkIsOpen();
        this.beforeGetValue(columnIndex);
        try {
            return UGetTypeConvertedValue.getBigDecimal(this.rows.get(this.current_row)[columnIndex - 1]);
        }
        catch (Exception e) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.conversion_error);
        }
    }

    @Override
    public synchronized BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    @Override
    public synchronized boolean isBeforeFirst() throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_scrollable);
    }

    @Override
    public synchronized boolean isAfterLast() throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_scrollable);
    }

    @Override
    public synchronized boolean isFirst() throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_scrollable);
    }

    @Override
    public synchronized boolean isLast() throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_scrollable);
    }

    @Override
    public synchronized void beforeFirst() throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_scrollable);
    }

    @Override
    public synchronized void afterLast() throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_scrollable);
    }

    @Override
    public synchronized boolean first() throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_scrollable);
    }

    @Override
    public synchronized boolean last() throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_scrollable);
    }

    @Override
    public synchronized int getRow() throws SQLException {
        this.checkIsOpen();
        if (this.current_row < this.num_of_rows && this.current_row >= 0) {
            return this.current_row + 1;
        }
        return 0;
    }

    @Override
    public synchronized boolean absolute(int row) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_scrollable);
    }

    @Override
    public synchronized boolean relative(int rows) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_scrollable);
    }

    @Override
    public synchronized boolean previous() throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_scrollable);
    }

    @Override
    public synchronized void setFetchDirection(int direction) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_scrollable);
    }

    @Override
    public synchronized int getFetchDirection() throws SQLException {
        this.checkIsOpen();
        return 1000;
    }

    @Override
    public synchronized void setFetchSize(int rows) throws SQLException {
        this.checkIsOpen();
        if (rows < 0) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.invalid_value);
        }
        this.fetch_size = rows;
    }

    @Override
    public synchronized int getFetchSize() throws SQLException {
        this.checkIsOpen();
        return this.fetch_size;
    }

    @Override
    public synchronized int getType() throws SQLException {
        this.checkIsOpen();
        return 1003;
    }

    @Override
    public synchronized int getConcurrency() throws SQLException {
        this.checkIsOpen();
        return 1007;
    }

    @Override
    public synchronized boolean rowUpdated() throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_sensitive);
    }

    @Override
    public synchronized boolean rowInserted() throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_sensitive);
    }

    @Override
    public synchronized boolean rowDeleted() throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_sensitive);
    }

    @Override
    public synchronized void updateNull(int columnIndex) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void updateByte(int columnIndex, byte x) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void updateShort(int columnIndex, short x) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void updateInt(int columnIndex, int x) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void updateLong(int columnIndex, long x) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void updateFloat(int columnIndex, float x) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void updateDouble(int columnIndex, double x) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void updateString(int columnIndex, String x) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void updateDate(int columnIndex, Date x) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void updateTime(int columnIndex, Time x) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void updateObject(int columnIndex, Object x) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void updateNull(String columnName) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void updateBoolean(String columnName, boolean x) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void updateByte(String columnName, byte x) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void updateShort(String columnName, short x) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void updateInt(String columnName, int x) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void updateLong(String columnName, long x) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void updateFloat(String columnName, float x) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void updateDouble(String columnName, double x) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void updateString(String columnName, String x) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void updateBytes(String columnName, byte[] x) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void updateDate(String columnName, Date x) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void updateTime(String columnName, Time x) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void updateObject(String columnName, Object x, int scale) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void updateObject(String columnName, Object x) throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void insertRow() throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void updateRow() throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void deleteRow() throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void refreshRow() throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_sensitive);
    }

    @Override
    public synchronized void cancelRowUpdates() throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void moveToInsertRow() throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized void moveToCurrentRow() throws SQLException {
        this.checkIsOpen();
        throw new CUBRIDException(CUBRIDJDBCErrorCode.non_updatable);
    }

    @Override
    public synchronized Statement getStatement() throws SQLException {
        this.checkIsOpen();
        return null;
    }

    @Override
    public Object getObject(int i, Map<String, Class<?>> map) throws SQLException {
        throw new CUBRIDException(CUBRIDJDBCErrorCode.not_supported);
    }

    @Override
    public Ref getRef(int i) throws SQLException {
        throw new CUBRIDException(CUBRIDJDBCErrorCode.not_supported);
    }

    @Override
    public Blob getBlob(int i) throws SQLException {
        throw new CUBRIDException(CUBRIDJDBCErrorCode.not_supported);
    }

    @Override
    public Clob getClob(int i) throws SQLException {
        throw new CUBRIDException(CUBRIDJDBCErrorCode.not_supported);
    }

    @Override
    public Array getArray(int i) throws SQLException {
        throw new CUBRIDException(CUBRIDJDBCErrorCode.not_supported);
    }

    @Override
    public synchronized Object getObject(String colName, Map<String, Class<?>> map) throws SQLException {
        throw new CUBRIDException(CUBRIDJDBCErrorCode.not_supported);
    }

    @Override
    public Ref getRef(String colName) throws SQLException {
        throw new CUBRIDException(CUBRIDJDBCErrorCode.not_supported);
    }

    @Override
    public Blob getBlob(String colName) throws SQLException {
        throw new CUBRIDException(CUBRIDJDBCErrorCode.not_supported);
    }

    @Override
    public Clob getClob(String colName) throws SQLException {
        throw new CUBRIDException(CUBRIDJDBCErrorCode.not_supported);
    }

    @Override
    public Array getArray(String colName) throws SQLException {
        throw new CUBRIDException(CUBRIDJDBCErrorCode.not_supported);
    }

    @Override
    public synchronized Date getDate(int columnIndex, Calendar cal) throws SQLException {
        this.checkIsOpen();
        return this.getDate(columnIndex);
    }

    @Override
    public synchronized Date getDate(String columnName, Calendar cal) throws SQLException {
        this.checkIsOpen();
        return this.getDate(columnName);
    }

    @Override
    public synchronized Time getTime(int columnIndex, Calendar cal) throws SQLException {
        this.checkIsOpen();
        return this.getTime(columnIndex);
    }

    @Override
    public synchronized Time getTime(String columnName, Calendar cal) throws SQLException {
        this.checkIsOpen();
        return this.getTime(columnName);
    }

    @Override
    public synchronized Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        this.checkIsOpen();
        return this.getTimestamp(columnIndex);
    }

    @Override
    public synchronized Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        this.checkIsOpen();
        return this.getTimestamp(columnName);
    }

    @Override
    public synchronized URL getURL(int columnIndex) throws SQLException {
        throw new CUBRIDException(CUBRIDJDBCErrorCode.not_supported);
    }

    @Override
    public synchronized URL getURL(String columnName) throws SQLException {
        throw new CUBRIDException(CUBRIDJDBCErrorCode.not_supported);
    }

    @Override
    public synchronized void updateArray(int columnIndex, Array x) throws SQLException {
        throw new CUBRIDException(CUBRIDJDBCErrorCode.not_supported);
    }

    @Override
    public synchronized void updateArray(String columnName, Array x) throws SQLException {
        throw new CUBRIDException(CUBRIDJDBCErrorCode.not_supported);
    }

    @Override
    public synchronized void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw new CUBRIDException(CUBRIDJDBCErrorCode.not_supported);
    }

    @Override
    public synchronized void updateBlob(String columnName, Blob x) throws SQLException {
        throw new CUBRIDException(CUBRIDJDBCErrorCode.not_supported);
    }

    @Override
    public synchronized void updateClob(int columnIndex, Clob x) throws SQLException {
        throw new CUBRIDException(CUBRIDJDBCErrorCode.not_supported);
    }

    @Override
    public synchronized void updateClob(String columnName, Clob x) throws SQLException {
        throw new CUBRIDException(CUBRIDJDBCErrorCode.not_supported);
    }

    @Override
    public synchronized void updateRef(int columnIndex, Ref x) throws SQLException {
        throw new CUBRIDException(CUBRIDJDBCErrorCode.not_supported);
    }

    @Override
    public synchronized void updateRef(String columnName, Ref x) throws SQLException {
        throw new CUBRIDException(CUBRIDJDBCErrorCode.not_supported);
    }

    synchronized void sortTuples(Comparator<Object> com) {
        Object[] temp = this.rows.toArray();
        Arrays.sort(temp, com);
        for (int i = 0; i < temp.length; ++i) {
            this.rows.set(i, (Object[])temp[i]);
        }
    }

    synchronized void addTuple(Object[] tuple) throws SQLException {
        if (tuple.length != this.num_of_columns) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.invalid_tuple);
        }
        Object[] newtuple = new Object[tuple.length];
        for (int i = 0; i < tuple.length; ++i) {
            newtuple[i] = tuple[i];
        }
        this.rows.add(newtuple);
        ++this.num_of_rows;
    }

    private void checkIsOpen() throws SQLException {
        if (this.is_closed) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.result_set_closed);
        }
    }

    private void beforeGetValue(int col) throws SQLException {
        if (this.current_row < 0 || this.current_row >= this.num_of_rows) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.invalid_row);
        }
        if (col < 1 || col > this.num_of_columns) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.invalid_index);
        }
        this.was_null = this.rows.get(this.current_row)[col - 1] == null;
    }

    private void addStream(InputStream s) throws SQLException {
        this.streams.add(s);
    }

    private void clearAllStreams() throws SQLException {
        Iterator<InputStream> iter = this.streams.iterator();
        try {
            while (iter.hasNext()) {
                iter.next().close();
                iter.remove();
            }
            this.streams.clear();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isClosed() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNClob(int columnIndex, NClob clob) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNClob(String columnLabel, NClob clob) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNString(int columnIndex, String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNString(String columnLabel, String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        throw new UnsupportedOperationException();
    }
}

