/*
 * Decompiled with CFR 0.152.
 */
package com.karasiq.tls.x509;

import com.karasiq.tls.internal.BCConversions$DigestAlgorithm$;
import com.karasiq.tls.internal.BCConversions$SignatureDigestAlgorithm$;
import com.karasiq.tls.internal.TLSUtils$;
import com.karasiq.tls.x509.CertExtension;
import com.karasiq.tls.x509.CertExtension$;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.bouncycastle.asn1.x509.AuthorityInformationAccess;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509ExtensionUtils;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.StringContext;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

public final class X509Utils$ {
    public static X509Utils$ MODULE$;
    private final Config config;

    static {
        new X509Utils$();
    }

    private Config config() {
        return this.config;
    }

    public boolean isCertificationAuthority(Certificate certificate) {
        X509CertificateHolder certHolder = new X509CertificateHolder(certificate);
        return BoxesRunTime.unboxToBoolean((Object)Option$.MODULE$.apply((Object)BasicConstraints.fromExtensions((Extensions)certHolder.getExtensions())).fold((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true, (Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isCA())));
    }

    public Option<Object> getPathLengthConstraint(Certificate certificate) {
        X509CertificateHolder certHolder = new X509CertificateHolder(certificate);
        return Option$.MODULE$.apply((Object)BasicConstraints.fromExtensions((Extensions)certHolder.getExtensions())).collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends BasicConstraints, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = A1.isCA() && A1.getPathLenConstraint() != null && A1.getPathLenConstraint().compareTo(BigInteger.ZERO) > 0 ? BoxesRunTime.boxToInteger((int)A1.getPathLenConstraint().intValue()) : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(BasicConstraints x1) {
                BasicConstraints basicConstraints = x1;
                boolean bl = basicConstraints.isCA() && basicConstraints.getPathLenConstraint() != null && basicConstraints.getPathLenConstraint().compareTo(BigInteger.ZERO) > 0;
                return bl;
            }
        });
    }

    public boolean isKeyUsageAllowed(Certificate certificate, int keyUsage) {
        return BoxesRunTime.unboxToBoolean((Object)Option$.MODULE$.apply((Object)KeyUsage.fromExtensions((Extensions)new X509CertificateHolder(certificate).getExtensions())).fold((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true, (Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.hasUsages(keyUsage))));
    }

    public Option<GeneralNames> alternativeNamesOf(Certificate certificate) {
        X509CertificateHolder certHolder = new X509CertificateHolder(certificate);
        return Option$.MODULE$.apply((Object)GeneralNames.fromExtensions((Extensions)certHolder.getExtensions(), (ASN1ObjectIdentifier)Extension.subjectAlternativeName));
    }

    public Option<ASN1Encodable> alternativeNameOf(Certificate certificate, int nameId) {
        return this.alternativeNamesOf(certificate).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$3.getNames())).find((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)X509Utils$.$anonfun$alternativeNameOf$2(nameId, x$4))).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getName()));
    }

    private Seq<String> verifyAlgorithms() {
        return JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(this.config().getStringList("key-id-verify-with"));
    }

    public Option<Object> verifyAuthorityIdentifier(Certificate certificate, Certificate issuer) {
        X509CertificateHolder certHolder = new X509CertificateHolder(certificate);
        return Option$.MODULE$.apply((Object)AuthorityKeyIdentifier.fromExtensions((Extensions)certHolder.getExtensions())).map((Function1 & Serializable & scala.Serializable)keyId -> BoxesRunTime.boxToBoolean((boolean)X509Utils$.$anonfun$verifyAuthorityIdentifier$1(issuer, keyId)));
    }

    public Option<Object> verifyPublicKeyIdentifier(Certificate certificate, SubjectPublicKeyInfo publicKey) {
        X509CertificateHolder certHolder = new X509CertificateHolder(certificate);
        return Option$.MODULE$.apply((Object)SubjectKeyIdentifier.fromExtensions((Extensions)certHolder.getExtensions())).map((Function1 & Serializable & scala.Serializable)keyId -> BoxesRunTime.boxToBoolean((boolean)X509Utils$.$anonfun$verifyPublicKeyIdentifier$1(publicKey, keyId)));
    }

    public Seq<String> getCrlDistributionUrls(Certificate certificate) {
        Seq urls = (Seq)CertExtension$.MODULE$.extensionsOf(certificate).collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends CertExtension, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 != null) {
                    ASN1ObjectIdentifier aSN1ObjectIdentifier = A1.id();
                    ASN1Encodable points = A1.value();
                    ASN1ObjectIdentifier aSN1ObjectIdentifier2 = Extension.cRLDistributionPoints;
                    ASN1ObjectIdentifier aSN1ObjectIdentifier3 = aSN1ObjectIdentifier;
                    if (!(aSN1ObjectIdentifier2 != null ? !aSN1ObjectIdentifier2.equals(aSN1ObjectIdentifier3) : aSN1ObjectIdentifier3 != null)) {
                        object = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])CRLDistPoint.getInstance((Object)points).getDistributionPoints())).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                            SeqLike seqLike;
                            DistributionPoint distributionPoint = x0$1;
                            if (distributionPoint != null) {
                                DistributionPoint distributionPoint2 = distributionPoint;
                                ASN1Encodable aSN1Encodable = distributionPoint2.getDistributionPoint().getName();
                                if (aSN1Encodable instanceof GeneralNames) {
                                    GeneralNames generalNames = (GeneralNames)aSN1Encodable;
                                    seqLike = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])generalNames.getNames())).collect((PartialFunction)new scala.Serializable(null){
                                        public static final long serialVersionUID = 0L;

                                        public final <A1 extends GeneralName, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                                            A1 A1 = x3;
                                            Object object = A1.getTagNo() == 6 ? A1.getName().toString() : function1.apply(x3);
                                            return (B1)object;
                                        }

                                        public final boolean isDefinedAt(GeneralName x3) {
                                            GeneralName generalName = x3;
                                            boolean bl = generalName.getTagNo() == 6;
                                            return bl;
                                        }
                                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))));
                                } else {
                                    seqLike = (SeqLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{aSN1Encodable.toString()}));
                                }
                            } else {
                                throw new MatchError((Object)distributionPoint);
                            }
                            SeqLike seqLike2 = seqLike;
                            return seqLike2;
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
                        return (B1)object;
                    }
                }
                object = function1.apply(x2);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(CertExtension x2) {
                CertExtension certExtension = x2;
                if (certExtension == null) return false;
                ASN1ObjectIdentifier aSN1ObjectIdentifier = certExtension.id();
                ASN1ObjectIdentifier aSN1ObjectIdentifier2 = Extension.cRLDistributionPoints;
                ASN1ObjectIdentifier aSN1ObjectIdentifier3 = aSN1ObjectIdentifier;
                if (aSN1ObjectIdentifier2 != null) {
                    if (!aSN1ObjectIdentifier2.equals(aSN1ObjectIdentifier3)) return false;
                    return true;
                }
                if (aSN1ObjectIdentifier3 == null) return true;
                return false;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.bouncycastle.asn1.x509.DistributionPoint )}, serializedLambda);
            }
        }, Seq$.MODULE$.canBuildFrom());
        return (Seq)urls.toSeq().flatten((Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs)));
    }

    public Option<String> getIssuerUrl(Certificate certificate) {
        return Option$.MODULE$.apply((Object)new X509CertificateHolder(certificate).getExtension(Extension.authorityInfoAccess)).flatMap((Function1 & Serializable & scala.Serializable)ext -> {
            AuthorityInformationAccess info = AuthorityInformationAccess.getInstance((Object)ext);
            return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])info.getAccessDescriptions())).find((Function1 & Serializable & scala.Serializable)d -> BoxesRunTime.boxToBoolean((boolean)X509Utils$.$anonfun$getIssuerUrl$2(d))).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.getAccessLocation().getName().toString());
        });
    }

    public Option<String> getOcspUrl(Certificate certificate) {
        return Option$.MODULE$.apply((Object)new X509CertificateHolder(certificate).getExtensions().getExtensionParsedValue(Extension.authorityInfoAccess)).flatMap((Function1 & Serializable & scala.Serializable)ext -> {
            AuthorityInformationAccess info = AuthorityInformationAccess.getInstance((Object)ext.toASN1Primitive());
            return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])info.getAccessDescriptions())).find((Function1 & Serializable & scala.Serializable)d -> BoxesRunTime.boxToBoolean((boolean)X509Utils$.$anonfun$getOcspUrl$2(d))).map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.getAccessLocation().getName().toString());
        });
    }

    public Instant expireDays(int days) {
        return Instant.now().plus((long)days, ChronoUnit.DAYS);
    }

    public Instant defaultExpire() {
        return this.expireDays(this.config().getInt("expire-days"));
    }

    public int defaultKeySize(String algorithm) {
        return this.config().getInt(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-key-size"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{algorithm.toLowerCase()})));
    }

    public String defaultKeySize$default$1() {
        return "RSA";
    }

    public String defaultSignatureHash() {
        return this.config().getString("sign-algorithm");
    }

    public ECParameterSpec defaultEllipticCurve() {
        return TLSUtils$.MODULE$.getEllipticCurve(this.config().getString("ecdsa-curve"));
    }

    public X500Name subject(String commonName, String country, String state, String locality, String organization, String organizationUnit, String email) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        BoxedUnit boxedUnit3;
        BoxedUnit boxedUnit4;
        BoxedUnit boxedUnit5;
        X500NameBuilder builder = new X500NameBuilder();
        Predef$.MODULE$.assert(commonName != null, (Function0 & Serializable & scala.Serializable)() -> "Common name required");
        X509Utils$.checkLength$1(commonName, X509Utils$.checkLength$default$2$1(), X509Utils$.checkLength$default$3$1());
        builder.addRDN(BCStyle.CN, commonName);
        if (country != null) {
            X509Utils$.checkLength$1(country, 2, 2);
            boxedUnit5 = builder.addRDN(BCStyle.C, country);
        } else {
            boxedUnit5 = BoxedUnit.UNIT;
        }
        if (state != null) {
            X509Utils$.checkLength$1(state, X509Utils$.checkLength$default$2$1(), X509Utils$.checkLength$default$3$1());
            boxedUnit4 = builder.addRDN(BCStyle.ST, state);
        } else {
            boxedUnit4 = BoxedUnit.UNIT;
        }
        if (locality != null) {
            X509Utils$.checkLength$1(locality, X509Utils$.checkLength$default$2$1(), X509Utils$.checkLength$default$3$1());
            boxedUnit3 = builder.addRDN(BCStyle.L, locality);
        } else {
            boxedUnit3 = BoxedUnit.UNIT;
        }
        if (organization != null) {
            X509Utils$.checkLength$1(organization, X509Utils$.checkLength$default$2$1(), X509Utils$.checkLength$default$3$1());
            boxedUnit2 = builder.addRDN(BCStyle.O, organization);
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if (organizationUnit != null) {
            X509Utils$.checkLength$1(organizationUnit, X509Utils$.checkLength$default$2$1(), X509Utils$.checkLength$default$3$1());
            boxedUnit = builder.addRDN(BCStyle.OU, organizationUnit);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Object object = email != null ? builder.addRDN(BCStyle.E, email) : BoxedUnit.UNIT;
        return builder.build();
    }

    public String subject$default$2() {
        return null;
    }

    public String subject$default$3() {
        return null;
    }

    public String subject$default$4() {
        return null;
    }

    public String subject$default$5() {
        return null;
    }

    public String subject$default$6() {
        return null;
    }

    public String subject$default$7() {
        return null;
    }

    public ContentVerifierProvider contentVerifierProvider(Certificate certificate) {
        return new JcaContentVerifierProviderBuilder().setProvider(TLSUtils$.MODULE$.provider()).build(new X509CertificateHolder(certificate));
    }

    public ContentSigner contentSigner(PrivateKey key, String hashAlg) {
        return new JcaContentSignerBuilder(BCConversions$SignatureDigestAlgorithm$.MODULE$.apply(key.getAlgorithm(), hashAlg)).setProvider(TLSUtils$.MODULE$.provider()).build(key);
    }

    public String contentSigner$default$2() {
        return this.defaultSignatureHash();
    }

    public X509ExtensionUtils extensionUtils(String digest) {
        DigestCalculator calculator = new JcaDigestCalculatorProviderBuilder().setProvider(TLSUtils$.MODULE$.provider()).build().get(BCConversions$DigestAlgorithm$.MODULE$.apply(digest));
        return new X509ExtensionUtils(calculator);
    }

    public String extensionUtils$default$1() {
        return this.config().getString("key-id-algorithm");
    }

    public static final /* synthetic */ boolean $anonfun$alternativeNameOf$2(int nameId$1, GeneralName x$4) {
        return x$4.getTagNo() == nameId$1;
    }

    public static final /* synthetic */ boolean $anonfun$verifyAuthorityIdentifier$3(AuthorityKeyIdentifier issuerId$1, GeneralNames x$6) {
        GeneralNames generalNames = x$6;
        GeneralNames generalNames2 = issuerId$1.getAuthorityCertIssuer();
        return !(generalNames != null ? !generalNames.equals(generalNames2) : generalNames2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$verifyAuthorityIdentifier$5(AuthorityKeyIdentifier issuerId$1, BigInteger x$7) {
        return BoxesRunTime.equalsNumNum((Number)x$7, (Number)issuerId$1.getAuthorityCertSerialNumber());
    }

    public static final /* synthetic */ boolean $anonfun$verifyAuthorityIdentifier$1(Certificate issuer$1, AuthorityKeyIdentifier keyId) {
        X509ExtensionUtils utils = MODULE$.extensionUtils(MODULE$.extensionUtils$default$1());
        AuthorityKeyIdentifier issuerId = utils.createAuthorityKeyIdentifier(new X509CertificateHolder(issuer$1));
        return BoxesRunTime.unboxToBoolean((Object)Option$.MODULE$.apply((Object)keyId.getAuthorityCertIssuer()).fold((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true, (Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)X509Utils$.$anonfun$verifyAuthorityIdentifier$3(issuerId, x$6)))) && BoxesRunTime.unboxToBoolean((Object)Option$.MODULE$.apply((Object)keyId.getAuthorityCertSerialNumber()).fold((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true, (Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)X509Utils$.$anonfun$verifyAuthorityIdentifier$5(issuerId, x$7)))) && Arrays.equals(issuerId.getKeyIdentifier(), keyId.getKeyIdentifier());
    }

    public static final /* synthetic */ boolean $anonfun$verifyPublicKeyIdentifier$1(SubjectPublicKeyInfo publicKey$1, SubjectKeyIdentifier keyId) {
        X509ExtensionUtils utils = MODULE$.extensionUtils(MODULE$.extensionUtils$default$1());
        SubjectKeyIdentifier issuerId = utils.createSubjectKeyIdentifier(publicKey$1);
        return Arrays.equals(issuerId.getKeyIdentifier(), keyId.getKeyIdentifier());
    }

    public static final /* synthetic */ boolean $anonfun$getIssuerUrl$2(AccessDescription d) {
        ASN1ObjectIdentifier aSN1ObjectIdentifier = d.getAccessMethod();
        ASN1ObjectIdentifier aSN1ObjectIdentifier2 = AccessDescription.id_ad_caIssuers;
        return !(aSN1ObjectIdentifier != null ? !aSN1ObjectIdentifier.equals(aSN1ObjectIdentifier2) : aSN1ObjectIdentifier2 != null) && d.getAccessLocation().getTagNo() == 6;
    }

    public static final /* synthetic */ boolean $anonfun$getOcspUrl$2(AccessDescription d) {
        ASN1ObjectIdentifier aSN1ObjectIdentifier = d.getAccessMethod();
        ASN1ObjectIdentifier aSN1ObjectIdentifier2 = AccessDescription.id_ad_ocsp;
        return !(aSN1ObjectIdentifier != null ? !aSN1ObjectIdentifier.equals(aSN1ObjectIdentifier2) : aSN1ObjectIdentifier2 != null) && d.getAccessLocation().getTagNo() == 6;
    }

    private static final void checkLength$1(String s, int max, int min) {
        Predef$.MODULE$.assert(s.length() >= min && s.length() <= max, (Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid data length: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{s})));
    }

    private static final int checkLength$default$2$1() {
        return 64;
    }

    private static final int checkLength$default$3$1() {
        return 1;
    }

    private X509Utils$() {
        MODULE$ = this;
        this.config = ConfigFactory.load().getConfig("karasiq.tls.x509-defaults");
    }
}

