/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.brave;

import com.github.kristofa.brave.SpanAndEndpoint;
import com.github.kristofa.brave.internal.Util;
import com.twitter.zipkin.gen.Annotation;
import com.twitter.zipkin.gen.AnnotationType;
import com.twitter.zipkin.gen.BinaryAnnotation;
import com.twitter.zipkin.gen.Endpoint;
import com.twitter.zipkin.gen.Span;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public abstract class AnnotationSubmitter {
    private static final Charset UTF_8 = Charset.forName("UTF-8");

    public static AnnotationSubmitter create(SpanAndEndpoint spanAndEndpoint) {
        return new AnnotationSubmitterImpl(spanAndEndpoint);
    }

    abstract SpanAndEndpoint spanAndEndpoint();

    public void submitAnnotation(String annotationName) {
        Span span = this.spanAndEndpoint().span();
        if (span != null) {
            Annotation annotation = new Annotation();
            annotation.setTimestamp(this.currentTimeMicroseconds());
            annotation.setHost(this.spanAndEndpoint().endpoint());
            annotation.setValue(annotationName);
            this.addAnnotation(span, annotation);
        }
    }

    public void submitBinaryAnnotation(String key, String value) {
        Span span = this.spanAndEndpoint().span();
        if (span != null) {
            Util.checkNotNull(value, "Null value", new Object[0]);
            ByteBuffer bb = ByteBuffer.wrap(value.getBytes(UTF_8));
            this.submitBinaryAnnotation(span, this.spanAndEndpoint().endpoint(), key, bb, AnnotationType.STRING);
        }
    }

    public void submitBinaryAnnotation(String key, int value) {
        this.submitBinaryAnnotation(key, String.valueOf(value));
    }

    private void submitBinaryAnnotation(Span span, Endpoint endpoint, String key, ByteBuffer value, AnnotationType annotationType) {
        Util.checkNotBlank(key, "Null or blank key", new Object[0]);
        Util.checkNotNull(value, "Null value", new Object[0]);
        BinaryAnnotation binaryAnnotation = new BinaryAnnotation();
        binaryAnnotation.setKey(key);
        binaryAnnotation.setValue(value);
        binaryAnnotation.setAnnotation_type(annotationType);
        binaryAnnotation.setHost(endpoint);
        this.addBinaryAnnotation(span, binaryAnnotation);
    }

    long currentTimeMicroseconds() {
        return System.currentTimeMillis() * 1000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAnnotation(Span span, Annotation annotation) {
        Span span2 = span;
        synchronized (span2) {
            span.addToAnnotations(annotation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addBinaryAnnotation(Span span, BinaryAnnotation ba) {
        Span span2 = span;
        synchronized (span2) {
            span.addToBinary_annotations(ba);
        }
    }

    AnnotationSubmitter() {
    }

    private static final class AnnotationSubmitterImpl
    extends AnnotationSubmitter {
        private final SpanAndEndpoint spanAndEndpoint;

        private AnnotationSubmitterImpl(SpanAndEndpoint spanAndEndpoint) {
            this.spanAndEndpoint = Util.checkNotNull(spanAndEndpoint, "Null spanAndEndpoint", new Object[0]);
        }

        @Override
        SpanAndEndpoint spanAndEndpoint() {
            return this.spanAndEndpoint;
        }
    }
}

