/*
 * Decompiled with CFR 0.152.
 */
package com.github.luben.zstd;

import com.github.luben.zstd.AutoCloseBase;
import com.github.luben.zstd.Zstd;
import com.github.luben.zstd.ZstdDictCompress;
import com.github.luben.zstd.ZstdException;
import com.github.luben.zstd.util.Native;
import java.nio.ByteBuffer;

public class ZstdCompressCtx
extends AutoCloseBase {
    private long nativePtr = 0L;
    private ZstdDictCompress compression_dict = null;

    private native void init();

    private native void free();

    public ZstdCompressCtx() {
        this.init();
        if (0L == this.nativePtr) {
            throw new IllegalStateException("ZSTD_createCompressCtx failed");
        }
        this.storeFence();
    }

    @Override
    void doClose() {
        if (this.nativePtr != 0L) {
            this.free();
            this.nativePtr = 0L;
        }
    }

    public void setLevel(int n) {
        if (this.nativePtr == 0L) {
            throw new IllegalStateException("Compression context is closed");
        }
        this.acquireSharedLock();
        this.setLevel0(n);
        this.releaseSharedLock();
    }

    private native void setLevel0(int var1);

    public void setChecksum(boolean bl) {
        if (this.nativePtr == 0L) {
            throw new IllegalStateException("Compression context is closed");
        }
        this.acquireSharedLock();
        this.setChecksum0(bl);
        this.releaseSharedLock();
    }

    private native void setChecksum0(boolean var1);

    public void setContentSize(boolean bl) {
        if (this.nativePtr == 0L) {
            throw new IllegalStateException("Compression context is closed");
        }
        this.acquireSharedLock();
        this.setContentSize0(bl);
        this.releaseSharedLock();
    }

    private native void setContentSize0(boolean var1);

    public void setDictID(boolean bl) {
        if (this.nativePtr == 0L) {
            throw new IllegalStateException("Compression context is closed");
        }
        this.acquireSharedLock();
        this.setDictID0(bl);
        this.releaseSharedLock();
    }

    private native void setDictID0(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadDict(ZstdDictCompress zstdDictCompress) {
        if (this.nativePtr == 0L) {
            throw new IllegalStateException("Compression context is closed");
        }
        this.acquireSharedLock();
        zstdDictCompress.acquireSharedLock();
        try {
            long l = this.loadCDictFast0(zstdDictCompress);
            if (Zstd.isError(l)) {
                throw new ZstdException(l);
            }
            this.compression_dict = zstdDictCompress;
        }
        finally {
            zstdDictCompress.releaseSharedLock();
            this.releaseSharedLock();
        }
    }

    private native long loadCDictFast0(ZstdDictCompress var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadDict(byte[] byArray) {
        if (this.nativePtr == 0L) {
            throw new IllegalStateException("Compression context is closed");
        }
        this.acquireSharedLock();
        try {
            long l = this.loadCDict0(byArray);
            if (Zstd.isError(l)) {
                throw new ZstdException(l);
            }
            this.compression_dict = null;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    private native long loadCDict0(byte[] var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long compressDirectByteBuffer(ByteBuffer byteBuffer, int n, int n2, ByteBuffer byteBuffer2, int n3, int n4) {
        if (this.nativePtr == 0L) {
            throw new IllegalStateException("Compression context is closed");
        }
        if (!byteBuffer2.isDirect()) {
            throw new IllegalArgumentException("srcBuff must be a direct buffer");
        }
        if (!byteBuffer.isDirect()) {
            throw new IllegalArgumentException("dstBuff must be a direct buffer");
        }
        this.acquireSharedLock();
        try {
            long l = this.compressDirectByteBuffer0(byteBuffer, n, n2, byteBuffer2, n3, n4);
            if (Zstd.isError(l)) {
                throw new ZstdException(l);
            }
            long l2 = l;
            return l2;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    private native long compressDirectByteBuffer0(ByteBuffer var1, int var2, int var3, ByteBuffer var4, int var5, int var6);

    static {
        Native.load();
    }
}

