/*
 * Decompiled with CFR 0.152.
 */
package org.meanbean.bean.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.meanbean.bean.info.BeanInformation;
import org.meanbean.bean.info.PropertyInformation;
import org.meanbean.bean.util.PropertyInformationFilter;
import org.meanbean.factories.ObjectCreationException;
import org.meanbean.factories.util.FactoryLookupStrategy;
import org.meanbean.lang.Factory;
import org.meanbean.test.Configuration;
import org.meanbean.util.ValidationHelper;

public class BeanPropertyValuesFactory
implements Factory<Map<String, Object>> {
    private final BeanInformation beanInformation;
    private final FactoryLookupStrategy factoryLookupStrategy;
    private final Configuration configuration;

    public BeanPropertyValuesFactory(BeanInformation beanInformation, FactoryLookupStrategy factoryLookupStrategy, Configuration configuration) {
        ValidationHelper.ensureExists("beanInformation", "populate bean", beanInformation);
        ValidationHelper.ensureExists("factoryLookupStrategy", "populate bean", factoryLookupStrategy);
        ValidationHelper.ensureExists("configuration", "populate bean", configuration);
        this.beanInformation = beanInformation;
        this.factoryLookupStrategy = factoryLookupStrategy;
        this.configuration = configuration;
    }

    @Override
    public Map<String, Object> create() throws ObjectCreationException {
        HashMap<String, Object> propertyValues = new HashMap<String, Object>();
        List<PropertyInformation> writableProperties = PropertyInformationFilter.filter(this.beanInformation.getProperties(), PropertyInformationFilter.PropertyVisibility.WRITABLE);
        writableProperties = PropertyInformationFilter.filter(writableProperties, this.configuration);
        for (PropertyInformation property : writableProperties) {
            String propertyName = property.getName();
            try {
                Factory<?> valueFactory = this.factoryLookupStrategy.getFactory(this.beanInformation, property, this.configuration);
                Object value = valueFactory.create();
                propertyValues.put(propertyName, value);
            }
            catch (Exception e) {
                String message = "Failed to create a value for property [" + propertyName + "].";
                throw new ObjectCreationException(message, e);
            }
        }
        return propertyValues;
    }
}

