/*
 * Decompiled with CFR 0.152.
 */
package org.meanbean.factories;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import org.meanbean.factories.FactoryCollection;
import org.meanbean.factories.FactoryLookup;
import org.meanbean.factories.NoSuchFactoryException;
import org.meanbean.lang.Factory;
import org.meanbean.util.Order;
import org.meanbean.util.RandomValueGenerator;
import org.meanbean.util.Types;

@Order(value=5000)
public class ArrayFactoryLookup
implements FactoryLookup {
    private final RandomValueGenerator randomValueGenerator = RandomValueGenerator.getInstance();
    private int maxSize = 8;

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxArrayLength) {
        this.maxSize = maxArrayLength;
    }

    @Override
    public <T> Factory<T> getFactory(Type typeToken) throws IllegalArgumentException, NoSuchFactoryException {
        return () -> this.randomArray(typeToken);
    }

    @Override
    public boolean hasFactory(Type type) {
        return Types.getRawType(type).isArray();
    }

    private Object randomArray(Type typeToken) {
        Class<?> clazz = Types.getRawType(typeToken);
        int length = this.randomValueGenerator.nextInt(this.maxSize);
        Factory<?> componentFactory = this.getComponentFactory(clazz);
        Object array = Array.newInstance(clazz.getComponentType(), length);
        for (int i = 0; i < length; ++i) {
            Array.set(array, i, componentFactory.create());
        }
        return array;
    }

    private Factory<?> getComponentFactory(Class<?> clazz) {
        FactoryCollection instance = FactoryCollection.getInstance();
        return instance.getFactory(clazz.getComponentType());
    }
}

