/*
 * Decompiled with CFR 0.152.
 */
package org.meanbean.factories;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.TransferQueue;
import org.meanbean.factories.FactoryCollection;
import org.meanbean.factories.FactoryLookup;
import org.meanbean.factories.NoSuchFactoryException;
import org.meanbean.lang.Factory;
import org.meanbean.util.Order;
import org.meanbean.util.RandomValueGenerator;
import org.meanbean.util.Types;

@Order(value=4000)
public class CollectionFactoryLookup
implements FactoryLookup {
    private final RandomValueGenerator randomValueGenerator = RandomValueGenerator.getInstance();
    private Map<Class<?>, Factory<?>> collectionFactories = CollectionFactoryLookup.buildDefaultCollectionFactories();
    private int maxSize = 8;

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxArrayLength) {
        this.maxSize = maxArrayLength;
    }

    @Override
    public <T> Factory<T> getFactory(Type typeToken) throws IllegalArgumentException, NoSuchFactoryException {
        return this.createCollectionPopulatingFactory(typeToken);
    }

    private Factory<?> findItemFactory(Type itemType) {
        FactoryCollection factoryCollection = FactoryCollection.getInstance();
        try {
            return factoryCollection.getFactory(itemType);
        }
        catch (NoSuchFactoryException e) {
            return factoryCollection.getFactory(Void.TYPE);
        }
    }

    @Override
    public boolean hasFactory(Type type) {
        Class<?> clazz = Types.getRawType(type);
        return !clazz.equals(Void.TYPE) && (Collection.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz));
    }

    private Type findElementType(Type type, int index) {
        if (type instanceof ParameterizedType) {
            return ((ParameterizedType)type).getActualTypeArguments()[index];
        }
        return String.class;
    }

    private Factory<?> createCollectionPopulatingFactory(Type typeToken) {
        Class<?> rawType = Types.getRawType(typeToken);
        Factory<Object> instanceFactory = this.findCollectionInstanceFactory(typeToken, rawType);
        Type itemType = this.findElementType(typeToken, 0);
        Factory<?> itemFactory = this.findItemFactory(itemType);
        if (Map.class.isAssignableFrom(rawType)) {
            return this.createMapPopulatingFactory(typeToken, instanceFactory, itemFactory);
        }
        Factory<Object> populatingFactory = () -> {
            Collection collection = (Collection)instanceFactory.create();
            int size = this.randomValueGenerator.nextInt(this.maxSize);
            for (int idx = 0; idx < size; ++idx) {
                collection.add(itemFactory.create());
            }
            return collection;
        };
        return populatingFactory;
    }

    private Factory<?> createMapPopulatingFactory(Type typeToken, Factory<Object> instanceFactory, Factory<?> itemFactory) {
        Type valueType = this.findElementType(typeToken, 1);
        Factory<?> valueFactory = this.findItemFactory(valueType);
        Factory<Object> populatingFactory = () -> {
            Map map = (Map)instanceFactory.create();
            int size = this.randomValueGenerator.nextInt(this.maxSize);
            for (int idx = 0; idx < size; ++idx) {
                map.put(itemFactory.create(), valueFactory.create());
            }
            return map;
        };
        return populatingFactory;
    }

    private <T> Factory<T> findCollectionInstanceFactory(Type type, Class<?> rawType) {
        if (this.isEnumMap(type, rawType)) {
            Type keyType = this.findElementType(type, 0);
            return () -> new EnumMap((Class)keyType);
        }
        if (this.isEnumSet(type, rawType)) {
            Type keyType = this.findElementType(type, 0);
            return () -> EnumSet.noneOf((Class)keyType);
        }
        Factory<Object> factory = this.collectionFactories.get(rawType);
        if (factory == null) {
            factory = () -> {
                try {
                    return rawType.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw new IllegalStateException("cannot create instance for " + rawType, e);
                }
            };
            this.collectionFactories.put(rawType, factory);
        }
        return factory;
    }

    private boolean isEnumSet(Type type, Class<?> rawType) {
        if (rawType.equals(EnumSet.class)) {
            return true;
        }
        Type keyType = this.findElementType(type, 0);
        if (rawType.equals(Set.class) && keyType instanceof Class) {
            return ((Class)keyType).isEnum();
        }
        return false;
    }

    private boolean isEnumMap(Type type, Class<?> rawType) {
        if (rawType.equals(EnumMap.class)) {
            return true;
        }
        Type keyType = this.findElementType(type, 0);
        if (rawType.equals(Map.class) && keyType instanceof Class) {
            return ((Class)keyType).isEnum();
        }
        return false;
    }

    private static Map<Class<?>, Factory<?>> buildDefaultCollectionFactories() {
        ConcurrentHashMap collectionFactories = new ConcurrentHashMap();
        collectionFactories.put(List.class, ArrayList::new);
        collectionFactories.put(Map.class, HashMap::new);
        collectionFactories.put(ConcurrentMap.class, ConcurrentHashMap::new);
        collectionFactories.put(SortedMap.class, TreeMap::new);
        collectionFactories.put(NavigableMap.class, TreeMap::new);
        collectionFactories.put(Set.class, HashSet::new);
        collectionFactories.put(SortedSet.class, TreeSet::new);
        collectionFactories.put(NavigableSet.class, TreeSet::new);
        collectionFactories.put(Collection.class, ArrayList::new);
        collectionFactories.put(Queue.class, LinkedList::new);
        collectionFactories.put(Deque.class, LinkedList::new);
        collectionFactories.put(BlockingQueue.class, LinkedBlockingQueue::new);
        collectionFactories.put(BlockingDeque.class, LinkedBlockingDeque::new);
        collectionFactories.put(TransferQueue.class, LinkedTransferQueue::new);
        return collectionFactories;
    }
}

