/*
 * Decompiled with CFR 0.152.
 */
package org.meanbean.factories;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Stream;
import org.meanbean.factories.FactoryCollection;
import org.meanbean.factories.FactoryLookup;
import org.meanbean.factories.NoSuchFactoryException;
import org.meanbean.lang.Factory;
import org.meanbean.util.Order;
import org.meanbean.util.ServiceDefinition;
import org.meanbean.util.ServiceFactory;

@Order(value=1000)
public class FactoryCollectionRepository
implements FactoryCollection {
    private final List<FactoryLookup> factoryLookups = new CopyOnWriteArrayList<FactoryLookup>();

    @Override
    public void addFactory(Class<?> clazz, Factory<?> factory) throws IllegalArgumentException {
        this.factoryCollections().forEach(factoryCollection -> factoryCollection.addFactory(clazz, factory));
    }

    @Override
    public void addFactoryLookup(FactoryLookup factoryLookup) {
        this.factoryLookups.add(0, factoryLookup);
    }

    @Override
    public <T> Factory<T> getFactory(Type type) throws IllegalArgumentException, NoSuchFactoryException {
        Optional<Factory> resultOptional = this.factoryLookups().filter(factoryCollection -> factoryCollection.hasFactory(type)).findFirst().map(factoryCollection -> factoryCollection.getFactory(type));
        if (resultOptional.isPresent()) {
            return resultOptional.get();
        }
        throw new NoSuchFactoryException("No factory found for " + type);
    }

    @Override
    public boolean hasFactory(Type type) throws IllegalArgumentException {
        return this.factoryLookups().anyMatch(factoryCollection -> factoryCollection.hasFactory(type));
    }

    Stream<FactoryLookup> factoryLookups() {
        Stream<FactoryLookup> lookups = this.servicesFrom(FactoryLookup.getServiceDefinition());
        Stream<FactoryCollection> services = Stream.concat(lookups, this.factoryCollections()).sorted(ServiceFactory.getComparator());
        return Stream.concat(this.factoryLookups.stream(), services);
    }

    private Stream<FactoryCollection> factoryCollections() {
        return this.servicesFrom(FactoryCollection.getServiceDefinition());
    }

    private <T> Stream<T> servicesFrom(ServiceDefinition<T> definition) {
        return definition.getServiceFactory().getAll().stream().filter(factoryCollection -> factoryCollection != this);
    }
}

