/*
 * Decompiled with CFR 0.152.
 */
package org.meanbean.factories;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import org.meanbean.factories.FactoryCollection;
import org.meanbean.factories.FactoryLookup;
import org.meanbean.factories.NoSuchFactoryException;
import org.meanbean.lang.Factory;
import org.meanbean.util.Order;
import org.meanbean.util.Types;

@Order(value=4000)
public class OptionalFactoryLookup
implements FactoryLookup {
    private static final Map<Class<?>, Class<?>> OPTIONAL_TO_ITEM_TYPE_MAP = OptionalFactoryLookup.createOptionalTypeMap();

    @Override
    public <T> Factory<T> getFactory(Type typeToken) throws IllegalArgumentException, NoSuchFactoryException {
        return this.createOptionalPopulatingFactory(typeToken);
    }

    private static Map<Class<?>, Class<?>> createOptionalTypeMap() {
        HashMap<Class, Class<Double>> map = new HashMap<Class, Class<Double>>();
        map.put(Optional.class, null);
        map.put(OptionalInt.class, Integer.class);
        map.put(OptionalLong.class, Long.class);
        map.put(OptionalDouble.class, Double.class);
        return Collections.unmodifiableMap(map);
    }

    private Factory<?> findItemFactory(Type itemType) {
        FactoryCollection factoryCollection = FactoryCollection.getInstance();
        try {
            return factoryCollection.getFactory(itemType);
        }
        catch (NoSuchFactoryException e) {
            return factoryCollection.getFactory(Void.TYPE);
        }
    }

    @Override
    public boolean hasFactory(Type type) {
        Class<?> clazz = Types.getRawType(type);
        return !clazz.equals(Void.TYPE) && this.isAssignableToOptional(clazz);
    }

    private boolean isAssignableToOptional(Class<?> clazz) {
        for (Class<?> optionalType : OPTIONAL_TO_ITEM_TYPE_MAP.keySet()) {
            if (!optionalType.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    private Type findElementType(Type type, int index) {
        if (type instanceof ParameterizedType) {
            return ((ParameterizedType)type).getActualTypeArguments()[index];
        }
        return String.class;
    }

    private Factory<?> createOptionalPopulatingFactory(Type typeToken) {
        Class<?> rawType = Types.getRawType(typeToken);
        return this.findInstanceFactory(typeToken, rawType);
    }

    private <T> Factory<T> findInstanceFactory(Type type, Class<?> rawType) {
        Factory<?> itemFactory;
        Class<?> itemType = OPTIONAL_TO_ITEM_TYPE_MAP.get(rawType);
        Factory<?> factory = itemFactory = itemType == null ? this.findItemFactory(this.findElementType(type, 0)) : this.findItemFactory(itemType);
        if (rawType.equals(Optional.class)) {
            return () -> Optional.ofNullable(itemFactory.create());
        }
        if (rawType.equals(OptionalInt.class)) {
            return () -> OptionalInt.of((Integer)itemFactory.create());
        }
        if (rawType.equals(OptionalLong.class)) {
            return () -> OptionalLong.of((Long)itemFactory.create());
        }
        if (rawType.equals(OptionalDouble.class)) {
            return () -> OptionalDouble.of((Double)itemFactory.create());
        }
        throw new IllegalArgumentException("Unknown optional type:" + type);
    }
}

