/*
 * Decompiled with CFR 0.152.
 */
package org.meanbean.factories.io;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.meanbean.factories.FactoryCollection;
import org.meanbean.factories.FactoryCollectionPlugin;
import org.meanbean.util.RandomValueGenerator;

public class FileFactory
implements FactoryCollectionPlugin {
    @Override
    public void initialize(FactoryCollection factoryCollection, RandomValueGenerator randomValueGenerator) {
        factoryCollection.addFactory(File.class, this::generateTempFile);
        factoryCollection.addFactory(Path.class, this::generateTempPath);
    }

    private File generateTempFile() {
        return this.generateTempPath().toFile();
    }

    private Path generateTempPath() {
        try {
            Path path = Files.createTempFile("mean-bean-file-factory-", ".txt", new FileAttribute[0]);
            Files.delete(path);
            return path;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

