/*
 * Decompiled with CFR 0.152.
 */
package org.meanbean.factories.time;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.util.function.Function;
import org.meanbean.factories.FactoryCollection;
import org.meanbean.factories.FactoryCollectionPlugin;
import org.meanbean.factories.NoSuchFactoryException;
import org.meanbean.factories.time.RandomClock;
import org.meanbean.lang.Factory;
import org.meanbean.util.RandomValueGenerator;

public class TimePlugin
implements FactoryCollectionPlugin {
    private RandomValueGenerator randomValueGenerator;
    private FactoryCollection factoryCollection;
    private Clock clock;

    public TimePlugin() {
    }

    public TimePlugin(Clock clock) {
        this.clock = clock;
    }

    @Override
    public void initialize(FactoryCollection factoryCollection, RandomValueGenerator randomValueGenerator) {
        this.randomValueGenerator = randomValueGenerator;
        this.factoryCollection = factoryCollection;
        if (this.clock == null) {
            this.clock = new RandomClock(randomValueGenerator);
        }
        this.addFactory(Clock.class, () -> this.clock);
        this.addFactory(Instant.class, this.newFactory(Instant::now));
        this.addFactory(LocalDate.class, this.newFactory(LocalDate::now));
        this.addFactory(LocalDateTime.class, this.newFactory(LocalDateTime::now));
        this.addFactory(LocalTime.class, this.newFactory(LocalTime::now));
        this.addFactory(OffsetDateTime.class, this.newFactory(OffsetDateTime::now));
        this.addFactory(OffsetTime.class, this.newFactory(OffsetTime::now));
        this.addFactory(MonthDay.class, this.newFactory(MonthDay::now));
        this.addFactory(Year.class, this.newFactory(Year::now));
        this.addFactory(YearMonth.class, this.newFactory(YearMonth::now));
        this.addFactory(ZonedDateTime.class, this.newFactory(ZonedDateTime::now));
        this.addFactory(ZoneId.class, this.clock::getZone);
        this.addFactory(ZoneOffset.class, this.newZoneOffsetFactory());
        this.addFactory(Duration.class, this.newDurationFactory());
        this.addFactory(Period.class, this.newPeroidFactory());
    }

    private Factory<ZoneOffset> newZoneOffsetFactory() {
        return () -> {
            int sign = this.randomValueGenerator.nextBoolean() ? 1 : -1;
            int hours = this.randomValueGenerator.nextInt(18);
            int minutes = this.randomValueGenerator.nextInt(59);
            int seconds = this.randomValueGenerator.nextInt(59);
            return ZoneOffset.ofHoursMinutesSeconds(sign * hours, sign * minutes, sign * seconds);
        };
    }

    private Factory<Period> newPeroidFactory() {
        Factory<LocalDate> localDateFactory = this.getFactory(LocalDate.class);
        return () -> Period.between((LocalDate)localDateFactory.create(), (LocalDate)localDateFactory.create());
    }

    private Factory<Duration> newDurationFactory() {
        Factory<LocalDateTime> localDateTimeFactory = this.getFactory(LocalDateTime.class);
        return () -> Duration.between((Temporal)localDateTimeFactory.create(), (Temporal)localDateTimeFactory.create());
    }

    private <T> void addFactory(Class<T> clazz, Factory<T> factory) throws IllegalArgumentException {
        this.factoryCollection.addFactory(clazz, factory);
    }

    private <T> Factory<T> getFactory(Class<T> clazz) throws IllegalArgumentException, NoSuchFactoryException {
        return this.factoryCollection.getFactory(clazz);
    }

    private <T> Factory<T> newFactory(Function<Clock, T> function) {
        return () -> function.apply(this.clock);
    }
}

