/*
 * Decompiled with CFR 0.152.
 */
package org.meanbean.factories.util;

import java.lang.reflect.Type;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.meanbean.bean.info.BeanInformation;
import org.meanbean.bean.info.BeanInformationFactory;
import org.meanbean.bean.info.PropertyInformation;
import org.meanbean.factories.BasicNewObjectInstanceFactory;
import org.meanbean.factories.FactoryCollection;
import org.meanbean.factories.NoSuchFactoryException;
import org.meanbean.factories.basic.EnumFactory;
import org.meanbean.factories.beans.PopulatedBeanFactory;
import org.meanbean.factories.util.FactoryLookupStrategy;
import org.meanbean.lang.Factory;
import org.meanbean.logging.$Logger;
import org.meanbean.logging.$LoggerFactory;
import org.meanbean.test.Configuration;
import org.meanbean.test.Warning;
import org.meanbean.util.RandomValueGenerator;
import org.meanbean.util.Types;
import org.meanbean.util.ValidationHelper;

public class BasicFactoryLookupStrategy
implements FactoryLookupStrategy {
    private static final Set<String> dynamicallyCreatedFactories = ConcurrentHashMap.newKeySet();
    private static final $Logger logger = $LoggerFactory.getLogger(BasicFactoryLookupStrategy.class);
    private final RandomValueGenerator randomValueGenerator;
    private final FactoryCollection factoryCollection;

    public BasicFactoryLookupStrategy(FactoryCollection factoryCollection, RandomValueGenerator randomValueGenerator) throws IllegalArgumentException {
        ValidationHelper.ensureExists("factoryCollection", "construct FactoryLookupStrategy", factoryCollection);
        ValidationHelper.ensureExists("randomValueGenerator", "construct FactoryLookupStrategy", randomValueGenerator);
        this.factoryCollection = factoryCollection;
        this.randomValueGenerator = randomValueGenerator;
    }

    @Override
    public Factory<?> getFactory(BeanInformation beanInformation, PropertyInformation propertyInformation, Configuration configuration) throws IllegalArgumentException, NoSuchFactoryException {
        ValidationHelper.ensureExists("beanInformation", "get factory", beanInformation);
        ValidationHelper.ensureExists("propertyInformation", "get factory", propertyInformation);
        return this.doGetFactory(beanInformation, propertyInformation, configuration);
    }

    private Factory<?> doGetFactory(BeanInformation beanInformation, PropertyInformation propertyInformation, Configuration configuration) {
        String propertyName = propertyInformation.getName();
        Type genericType = propertyInformation.getReadMethodReturnType();
        Class<?> propertyType = Types.getRawType(genericType);
        if (this.propertyHasOverrideFactoryInConfiguration(propertyName, configuration)) {
            return this.getPropertyOverrideFactoryFromConfiguration(propertyName, configuration);
        }
        if (this.propertyTypeHasRegisteredFactory(propertyInformation)) {
            return this.getPropertyTypeRegisteredFactory(propertyInformation);
        }
        if (this.propertyIsAnEnum(propertyType)) {
            return this.getAndCachePropertyEnumFactory(propertyType);
        }
        if (this.propertyIsNotTheSameTypeAsItsParent(beanInformation, propertyType)) {
            return this.createTestedPopulatedBeanFactory(beanInformation, propertyName, propertyType, configuration);
        }
        return this.createTestedUnpopulatedBeanFactory(beanInformation, propertyName, propertyType, configuration);
    }

    private boolean propertyHasOverrideFactoryInConfiguration(String propertyName, Configuration configuration) {
        return configuration != null && configuration.hasOverrideFactory(propertyName);
    }

    private Factory<?> getPropertyOverrideFactoryFromConfiguration(String propertyName, Configuration configuration) {
        return configuration.getOverrideFactory(propertyName);
    }

    private boolean propertyTypeHasRegisteredFactory(PropertyInformation propertyType) {
        Type genericPropertyType = propertyType.getReadMethodReturnType();
        return this.factoryCollection.hasFactory(genericPropertyType);
    }

    private Factory<?> getPropertyTypeRegisteredFactory(PropertyInformation propertyType) {
        Type genericPropertyType = propertyType.getReadMethodReturnType();
        return this.factoryCollection.getFactory(genericPropertyType);
    }

    private boolean propertyIsAnEnum(Class<?> propertyType) {
        return propertyType.isEnum();
    }

    private Factory<?> getAndCachePropertyEnumFactory(Class<?> propertyType) {
        EnumFactory factory = this.getEnumPropertyFactory(propertyType);
        this.cacheEnumPropertyFactory(propertyType, factory);
        return factory;
    }

    private EnumFactory getEnumPropertyFactory(Class<?> propertyType) {
        return new EnumFactory(propertyType, this.randomValueGenerator);
    }

    private void cacheEnumPropertyFactory(Class<?> propertyType, EnumFactory enumFactory) {
        this.factoryCollection.addFactory(propertyType, enumFactory);
    }

    private boolean propertyIsNotTheSameTypeAsItsParent(BeanInformation beanInformation, Class<?> propertyType) {
        return !propertyType.equals(beanInformation.getBeanClass());
    }

    private Factory<?> createTestedPopulatedBeanFactory(BeanInformation beanInformation, String propertyName, Class<?> propertyType, Configuration configuration) {
        try {
            this.onDynamicFactoryCreation(beanInformation, propertyName, propertyType, configuration);
            Factory<?> populatedBeanFactory = this.createPopulatedBeanFactory(propertyType, configuration);
            this.testPopulatedBeanFactory(populatedBeanFactory);
            return populatedBeanFactory;
        }
        catch (Exception e) {
            String message = "Failed to find suitable Factory for property=[" + propertyName + "] of type=[" + propertyType + "]. Please register a custom Factory.";
            throw new NoSuchFactoryException(message, e);
        }
    }

    private void onDynamicFactoryCreation(BeanInformation beanInformation, String propertyName, Class<?> propertyType, Configuration configuration) {
        if (this.isLikelyNewDynamicallyCreatedFactoryType(beanInformation, propertyType, configuration)) {
            logger.info("Using dynamically created factory for [{}] of type [{}] because a custom Factory cannot be found.", propertyName, propertyType.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isLikelyNewDynamicallyCreatedFactoryType(BeanInformation beanInformation, Class<?> propertyType, Configuration configuration) {
        if (configuration != null && configuration.isSuppressedWarning(Warning.DYNAMICALLY_CREATED_FACTORY)) {
            return false;
        }
        if (dynamicallyCreatedFactories.size() > 1000) {
            Set<String> set = dynamicallyCreatedFactories;
            synchronized (set) {
                dynamicallyCreatedFactories.removeIf(value -> dynamicallyCreatedFactories.size() > 50);
            }
        }
        String key = beanInformation.getBeanClass().getName() + "." + propertyType.getName();
        return dynamicallyCreatedFactories.add(key);
    }

    private Factory<?> createPopulatedBeanFactory(Class<?> propertyType, Configuration configuration) {
        BeanInformationFactory beanInformationFactory = BeanInformationFactory.getInstance();
        BeanInformation propertyBeanInformation = beanInformationFactory.create(propertyType);
        return new PopulatedBeanFactory(propertyBeanInformation, this, configuration);
    }

    private void testPopulatedBeanFactory(Factory<?> equivalentPopulatedBeanFactory) {
        equivalentPopulatedBeanFactory.create();
    }

    private Factory<?> createTestedUnpopulatedBeanFactory(BeanInformation beanInformation, String propertyName, Class<?> propertyType, Configuration configuration) {
        try {
            this.onDynamicFactoryCreation(beanInformation, propertyName, propertyType, configuration);
            Factory<?> unpopulatedBeanFactory = this.createUnpopulatedBeanFactory(propertyType);
            this.testUnpopulatedBeanFactory(unpopulatedBeanFactory);
            return unpopulatedBeanFactory;
        }
        catch (Exception e) {
            String message = "Failed to find suitable Factory for property=[" + propertyName + "] of type=[" + propertyType + "]. Please register a custom Factory.";
            throw new NoSuchFactoryException(message, e);
        }
    }

    private Factory<?> createUnpopulatedBeanFactory(Class<?> propertyType) {
        return BasicNewObjectInstanceFactory.findBeanFactory(propertyType);
    }

    private void testUnpopulatedBeanFactory(Factory<?> basicFactory) {
        basicFactory.create();
    }
}

