/*
 * Decompiled with CFR 0.152.
 */
package org.meanbean.logging;

import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.meanbean.logging.$Logger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class $LoggerFactory {
    private static $LoggerFactory INSTANCE = new $LoggerFactory();

    public static $Logger getLogger(Class<?> clazz) {
        return INSTANCE.createLogger(clazz);
    }

    protected $Logger createLogger(Class<?> clazz) {
        return $LoggerFactory.createLogger(clazz, Slf4jLogger::new, Log4j2Logger::new);
    }

    @SafeVarargs
    private static $Logger createLogger(Class<?> clazz, Function<Class<?>, $Logger> ... factories) {
        for (Function<Class<?>, $Logger> factory : factories) {
            try {
                return factory.apply(clazz);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
            }
        }
        return new NullLogger();
    }

    private static class NullLogger
    implements $Logger {
        private NullLogger() {
        }

        @Override
        public boolean isTraceEnabled() {
            return false;
        }

        @Override
        public void trace(String format, Object ... arguments) {
        }

        @Override
        public boolean isDebugEnabled() {
            return false;
        }

        @Override
        public void debug(String format, Object ... arguments) {
        }

        @Override
        public boolean isInfoEnabled() {
            return false;
        }

        @Override
        public void info(String format, Object ... arguments) {
        }

        @Override
        public boolean isWarnEnabled() {
            return false;
        }

        @Override
        public void warn(String format, Object ... arguments) {
        }

        @Override
        public boolean isErrorEnabled() {
            return false;
        }

        @Override
        public void error(String format, Object ... arguments) {
        }
    }

    private static class Log4j2Logger
    implements $Logger {
        private final org.apache.logging.log4j.Logger logger;

        public Log4j2Logger(Class<?> clazz) {
            this.logger = LogManager.getLogger(clazz);
        }

        @Override
        public boolean isTraceEnabled() {
            return this.logger.isTraceEnabled();
        }

        @Override
        public void trace(String format, Object ... arguments) {
            this.logger.trace(format, arguments);
        }

        @Override
        public boolean isDebugEnabled() {
            return this.logger.isDebugEnabled();
        }

        @Override
        public void debug(String format, Object ... arguments) {
            this.logger.debug(format, arguments);
        }

        @Override
        public boolean isInfoEnabled() {
            return this.logger.isInfoEnabled();
        }

        @Override
        public void info(String format, Object ... arguments) {
            this.logger.info(format, arguments);
        }

        @Override
        public boolean isWarnEnabled() {
            return this.logger.isWarnEnabled();
        }

        @Override
        public void warn(String format, Object ... arguments) {
            this.logger.warn(format, arguments);
        }

        @Override
        public boolean isErrorEnabled() {
            return this.logger.isErrorEnabled();
        }

        @Override
        public void error(String format, Object ... arguments) {
            this.logger.error(format, arguments);
        }
    }

    private static class Slf4jLogger
    implements $Logger {
        private final Logger logger;

        public Slf4jLogger(Class<?> clazz) {
            this.logger = LoggerFactory.getLogger(clazz);
        }

        @Override
        public boolean isTraceEnabled() {
            return this.logger.isTraceEnabled();
        }

        @Override
        public void trace(String format, Object ... arguments) {
            this.logger.trace(format, arguments);
        }

        @Override
        public boolean isDebugEnabled() {
            return this.logger.isDebugEnabled();
        }

        @Override
        public void debug(String format, Object ... arguments) {
            this.logger.debug(format, arguments);
        }

        @Override
        public boolean isInfoEnabled() {
            return this.logger.isInfoEnabled();
        }

        @Override
        public void info(String format, Object ... arguments) {
            this.logger.info(format, arguments);
        }

        @Override
        public boolean isWarnEnabled() {
            return this.logger.isWarnEnabled();
        }

        @Override
        public void warn(String format, Object ... arguments) {
            this.logger.warn(format, arguments);
        }

        @Override
        public boolean isErrorEnabled() {
            return this.logger.isErrorEnabled();
        }

        @Override
        public void error(String format, Object ... arguments) {
            this.logger.error(format, arguments);
        }
    }
}

