/*
 * Decompiled with CFR 0.152.
 */
package org.meanbean.test;

import java.lang.reflect.Type;
import java.net.URL;
import java.util.concurrent.atomic.AtomicBoolean;
import org.meanbean.bean.info.PropertyInformation;
import org.meanbean.logging.$Logger;
import org.meanbean.logging.$LoggerFactory;
import org.meanbean.test.BeanTestException;
import org.meanbean.test.internal.EqualityTest;
import org.meanbean.util.AssertionUtils;
import org.meanbean.util.Types;
import org.meanbean.util.ValidationHelper;

public class BeanPropertyTester {
    public void testProperty(Object bean, PropertyInformation property, Object testValue, EqualityTest equalityTest) throws IllegalArgumentException, AssertionError, BeanTestException {
        ValidationHelper.ensureExists("bean", "test property", bean);
        ValidationHelper.ensureExists("property", "test property", property);
        ValidationHelper.ensureExists("testValue", "test property", testValue);
        ValidationHelper.ensureExists("equalityTest", "test property", (Object)equalityTest);
        String propertyName = property.getName();
        if (!property.isReadableWritable()) {
            throw new IllegalArgumentException("Cannot test property [" + propertyName + "] - property must be readable and writable.");
        }
        if (!this.typesAreCompatible(testValue.getClass(), property.getWriteMethodParameterType())) {
            String msg = String.format("Cannot test property [%s] - testValue must be same type as property. Expected %s but found %s", propertyName, testValue.getClass(), property.getWriteMethodParameterType());
            throw new IllegalArgumentException(msg);
        }
        try {
            property.getWriteMethod().invoke(bean, testValue);
            Object readMethodOutput = property.getReadMethod().invoke(bean, new Object[0]);
            UrlEqualityTestWarning.ifNeeded(equalityTest, bean, propertyName, testValue);
            UrlEqualityTestWarning.ifNeeded(equalityTest, bean, propertyName, readMethodOutput);
            if (!equalityTest.test(testValue, readMethodOutput)) {
                String message = "Property [" + propertyName + "] getter did not return test value. Expected [" + testValue + "] but getter returned [" + readMethodOutput + "].";
                AssertionUtils.fail(message);
            }
        }
        catch (Exception e) {
            throw BeanPropertyTester.throwException(property, e);
        }
    }

    static BeanTestException throwException(PropertyInformation property, Exception e) {
        String propertyName = property.getName();
        String message = "Failed to test property [" + propertyName + "] due to Exception [" + e.getClass().getName() + "]: [" + e.getMessage() + "].";
        throw new BeanTestException(message, e);
    }

    protected boolean typesAreCompatible(Class<?> classA, Type superType) {
        Class<?> superClass = Types.getRawType(superType);
        if (!classA.isPrimitive() && !superClass.isPrimitive()) {
            return superClass.isAssignableFrom(classA);
        }
        return classA.getSimpleName().equals(classA.getSimpleName());
    }

    private static class UrlEqualityTestWarning {
        private static final AtomicBoolean printed = new AtomicBoolean();

        private UrlEqualityTestWarning() {
        }

        private static void ifNeeded(EqualityTest equalityTest, Object bean, String propertyName, Object propertyValue) {
            if (equalityTest != EqualityTest.LOGICAL) {
                return;
            }
            if (propertyValue instanceof URL && !printed.getAndSet(true)) {
                $Logger logger = $LoggerFactory.getLogger(BeanPropertyTester.class);
                logger.warn("Bean '{}' has URL property '{}'. Equality tests on URL can be slow. Consider ignoring the property.", bean.getClass().getName(), propertyName);
            }
        }
    }
}

