/*
 * Decompiled with CFR 0.152.
 */
package org.meanbean.test;

import com.github.meanbeanlib.mirror.SerializableLambdas;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import org.meanbean.bean.info.BeanInformationFactory;
import org.meanbean.factories.FactoryCollection;
import org.meanbean.factories.FactoryLookup;
import org.meanbean.factories.NoSuchFactoryException;
import org.meanbean.factories.util.FactoryLookupStrategy;
import org.meanbean.lang.Factory;
import org.meanbean.test.BeanPropertyTester;
import org.meanbean.test.BeanTester;
import org.meanbean.test.Configuration;
import org.meanbean.test.EqualsMethodTester;
import org.meanbean.test.HashCodeMethodTester;
import org.meanbean.test.ToStringMethodTester;
import org.meanbean.util.PropertyNameFinder;
import org.meanbean.util.RandomValueGenerator;
import org.meanbean.util.ServiceFactory;
import org.meanbean.util.ValidationHelper;

public class BeanTesterBuilder {
    private RandomValueGenerator randomValueGenerator;
    private FactoryCollection factoryCollection;
    private FactoryLookupStrategy factoryLookupStrategy;
    private BeanInformationFactory beanInformationFactory;
    private BeanPropertyTester beanPropertyTester;
    private Map<Class<?>, Configuration> customConfigurations;
    private Configuration defaultConfiguration;

    public static BeanTesterBuilder newBeanTesterBuilder() {
        return new BeanTesterBuilder();
    }

    static BeanTesterBuilder newBeanTesterBuilderWithInheritedContext() {
        return new BeanTesterBuilder(ServiceFactory::createContextIfNeeded);
    }

    public static BeanTester newBeanTester() {
        return new BeanTesterBuilder().build();
    }

    public static EqualsMethodTester newEqualsMethodTester() {
        return new BeanTesterBuilder().buildEqualsMethodTester();
    }

    public static HashCodeMethodTester newHashCodeMethodTester() {
        return new HashCodeMethodTester();
    }

    public static ToStringMethodTester newToStringMethodTester() {
        return new ToStringMethodTester(Configuration.defaultConfigurationProvider());
    }

    private BeanTesterBuilder() {
        this(ServiceFactory::createContext);
    }

    private BeanTesterBuilder(Consumer<BeanTesterBuilder> contextCreator) {
        contextCreator.accept(this);
        this.randomValueGenerator = RandomValueGenerator.getInstance();
        this.factoryCollection = FactoryCollection.getInstance();
        this.factoryLookupStrategy = FactoryLookupStrategy.getInstance();
        this.beanInformationFactory = BeanInformationFactory.getInstance();
        this.beanPropertyTester = new BeanPropertyTester();
        this.customConfigurations = new ConcurrentHashMap();
        this.defaultConfiguration = Configuration.defaultConfiguration();
    }

    public RandomValueGenerator getRandomValueGenerator() {
        return this.randomValueGenerator;
    }

    public BeanTesterBuilder setRandomValueGenerator(RandomValueGenerator randomValueGenerator) {
        this.randomValueGenerator = randomValueGenerator;
        return this;
    }

    public FactoryCollection getFactoryCollection() {
        return this.factoryCollection;
    }

    public BeanTesterBuilder setFactoryCollection(FactoryCollection factoryCollection) {
        this.factoryCollection = factoryCollection;
        return this;
    }

    public FactoryLookupStrategy getFactoryLookupStrategy() {
        return this.factoryLookupStrategy;
    }

    public BeanTesterBuilder setFactoryLookupStrategy(FactoryLookupStrategy factoryLookupStrategy) {
        this.factoryLookupStrategy = factoryLookupStrategy;
        return this;
    }

    public BeanInformationFactory getBeanInformationFactory() {
        return this.beanInformationFactory;
    }

    public BeanTesterBuilder setBeanInformationFactory(BeanInformationFactory beanInformationFactory) {
        this.beanInformationFactory = beanInformationFactory;
        return this;
    }

    public BeanPropertyTester getBeanPropertyTester() {
        return this.beanPropertyTester;
    }

    public BeanTesterBuilder setBeanPropertyTester(BeanPropertyTester beanPropertyTester) {
        this.beanPropertyTester = beanPropertyTester;
        return this;
    }

    public <T> BeanTesterBuilder registerFactory(Class<T> clazz, Factory<? extends T> factory) {
        this.getFactoryCollection().addFactory(clazz, factory);
        return this;
    }

    public <T> BeanTesterBuilder registerTypeHierarchyFactory(final Class<T> baseType, final Factory<T> factory) {
        this.getFactoryCollection().addFactoryLookup(new FactoryLookup(){

            @Override
            public boolean hasFactory(Type type) throws IllegalArgumentException {
                return type instanceof Class && baseType.isAssignableFrom((Class)type);
            }

            public <E> Factory<E> getFactory(Type type) throws IllegalArgumentException, NoSuchFactoryException {
                if (this.hasFactory(type)) {
                    return factory;
                }
                throw new NoSuchFactoryException("No factory for " + type);
            }
        });
        return this;
    }

    public int getDefaultIterations() {
        return this.defaultConfiguration.getIterations();
    }

    public BeanTesterBuilder setDefaultIterations(int iterations) {
        this.defaultConfiguration.setIterations(iterations);
        return this;
    }

    public int getIterations(Class<?> beanClass) {
        return this.getConfigurationFor(beanClass).getIterations();
    }

    public BeanTesterBuilder setIterations(Class<?> beanClass, int num) {
        this.getConfigurationFor(beanClass).setIterations(num);
        return this;
    }

    public BeanTesterBuilder addIgnoredPropertyName(Class<?> beanClass, String property) throws IllegalArgumentException {
        ValidationHelper.ensureExists("property", "add property to ignored properties collection", property);
        this.getConfigurationFor(beanClass).getIgnoredProperties().add(property);
        return this;
    }

    public <T, S> BeanTesterBuilder addIgnoredProperty(Class<T> beanClass, SerializableLambdas.SerializableFunction1<T, S> beanGetter) throws IllegalArgumentException {
        String propertyName = PropertyNameFinder.findPropertyName(beanClass, beanGetter);
        return this.addIgnoredPropertyName(beanClass, propertyName);
    }

    public <T> BeanTesterBuilder addOverrideFactory(Class<T> beanClass, String property, Factory<T> factory) throws IllegalArgumentException {
        ValidationHelper.ensureExists("beanClass", "add override Factory", beanClass);
        ValidationHelper.ensureExists("property", "add override Factory", property);
        ValidationHelper.ensureExists("factory", "add override Factory", factory);
        this.getConfigurationFor(beanClass).getOverrideFactories().put(property, factory);
        return this;
    }

    public <T, S> BeanTesterBuilder addOverridePropertyFactory(Class<T> beanClass, SerializableLambdas.SerializableFunction1<T, S> beanGetter, Factory<S> factory) throws IllegalArgumentException {
        ValidationHelper.ensureExists("beanClass", "add override Factory", beanClass);
        ValidationHelper.ensureExists("beanGetter", "add override Factory", beanGetter);
        ValidationHelper.ensureExists("factory", "add override Factory", factory);
        String propertyName = PropertyNameFinder.findPropertyName(beanClass, beanGetter);
        this.getConfigurationFor(beanClass).getOverrideFactories().put(propertyName, factory);
        return this;
    }

    public <T, S> BeanTesterBuilder addEqualsInsignificantProperty(Class<T> beanClass, String propertyName) {
        ValidationHelper.ensureExists("beanClass", "add equals insignificantProperty", beanClass);
        ValidationHelper.ensureExists("propertyName", "add equals insignificantProperty", propertyName);
        this.getConfigurationFor(beanClass).getEqualsInsignificantProperties().add(propertyName);
        return this;
    }

    public <T, S> BeanTesterBuilder addEqualsInsignificantProperty(Class<T> beanClass, SerializableLambdas.SerializableFunction1<T, S> beanGetter) {
        ValidationHelper.ensureExists("beanClass", "add equals insignificantProperty", beanClass);
        ValidationHelper.ensureExists("beanGetter", "add equals insignificantProperty", beanGetter);
        String propertyName = PropertyNameFinder.findPropertyName(beanClass, beanGetter);
        return this.addEqualsInsignificantProperty(beanClass, propertyName);
    }

    Configuration getConfigurationFor(Class<?> clazz) {
        return this.customConfigurations.computeIfAbsent(clazz, key -> Configuration.defaultMutableConfiguration(this.defaultConfiguration.getIterations()));
    }

    public BeanTester build() {
        return new BeanTester(this.randomValueGenerator, this.factoryCollection, this.factoryLookupStrategy, this.beanInformationFactory, this.beanPropertyTester, this.createConfigurationProvider());
    }

    public EqualsMethodTester buildEqualsMethodTester() {
        return EqualsMethodTester.createWithInheritedContext(this.createConfigurationProvider());
    }

    public HashCodeMethodTester buildHashCodeMethodTester() {
        return HashCodeMethodTester.createWithInheritedContext(this.createConfigurationProvider());
    }

    public ToStringMethodTester buildToStringMethodTester() {
        return ToStringMethodTester.createWithInheritedContext(this.createConfigurationProvider());
    }

    private Function<Class<?>, Configuration> createConfigurationProvider() {
        return Configuration.customConfigurationProvider(this.customConfigurations, this.defaultConfiguration);
    }
}

