/*
 * Decompiled with CFR 0.152.
 */
package org.meanbean.test;

import java.util.function.Consumer;
import org.meanbean.test.BeanVerifierImpl;
import org.meanbean.test.VerifierSettings;
import org.meanbean.test.VerifierSettingsEditor;
import org.meanbean.util.ClassPathUtils;

public interface BeanVerifier {
    public static BeanVerifier forClass(Class<?> beanClass) {
        return new BeanVerifierImpl(beanClass);
    }

    public static void verifyBean(Class<?> beanClass) {
        BeanVerifier.forClass(beanClass).verify();
    }

    public static void verifyBeans(Class<?> ... beanClasses) {
        for (Class<?> beanClass : beanClasses) {
            try {
                BeanVerifier.verifyBean(beanClass);
            }
            catch (AssertionError | RuntimeException e) {
                throw new AssertionError("Cannot verify bean type " + beanClass.getName(), (Throwable)e);
            }
        }
    }

    public static void verifyBeansIn(String packageName) {
        Class<?>[] beanClasses = ClassPathUtils.findClassesIn(packageName);
        BeanVerifier.verifyBeans(beanClasses);
    }

    public static void verifyBeansIn(Package packageObj) {
        BeanVerifier.verifyBeansIn(packageObj.getName());
    }

    public BeanVerifier withSettings(Consumer<VerifierSettings> var1);

    public VerifierSettingsEditor editSettings();

    public BeanVerifier verifyEqualsAndHashCode();

    public BeanVerifier verifyGettersAndSetters();

    public BeanVerifier verifyToString();

    default public void verify() {
        this.verifyGettersAndSetters().verifyEqualsAndHashCode().verifyToString();
    }
}

