/*
 * Decompiled with CFR 0.152.
 */
package org.meanbean.test;

import java.util.function.Consumer;
import java.util.function.Function;
import org.meanbean.bean.info.BeanInformation;
import org.meanbean.bean.info.BeanInformationFactory;
import org.meanbean.factories.FactoryCollection;
import org.meanbean.factories.equivalent.EquivalentPopulatedBeanFactory;
import org.meanbean.factories.util.FactoryLookupStrategy;
import org.meanbean.lang.EquivalentFactory;
import org.meanbean.test.Configuration;
import org.meanbean.util.AssertionUtils;
import org.meanbean.util.RandomValueGenerator;
import org.meanbean.util.ServiceFactory;
import org.meanbean.util.ValidationHelper;

public class HashCodeMethodTester {
    private final RandomValueGenerator randomValueGenerator;
    private final FactoryCollection factoryCollection;
    private final FactoryLookupStrategy factoryLookupStrategy;
    private final BeanInformationFactory beanInformationFactory;
    private final Function<Class<?>, Configuration> configurationProvider;

    public HashCodeMethodTester() {
        this(ServiceFactory::createContext, Configuration.defaultConfigurationProvider());
    }

    static HashCodeMethodTester createWithInheritedContext(Function<Class<?>, Configuration> configurationProvider) {
        return new HashCodeMethodTester(ServiceFactory::createContextIfNeeded, configurationProvider);
    }

    private HashCodeMethodTester(Consumer<HashCodeMethodTester> contextCreator, Function<Class<?>, Configuration> configurationProvider) {
        contextCreator.accept(this);
        this.randomValueGenerator = RandomValueGenerator.getInstance();
        this.factoryCollection = FactoryCollection.getInstance();
        this.factoryLookupStrategy = FactoryLookupStrategy.getInstance();
        this.beanInformationFactory = BeanInformationFactory.getInstance();
        this.configurationProvider = configurationProvider;
    }

    public void testHashCodeMethod(EquivalentFactory<?> factory) throws IllegalArgumentException, AssertionError {
        ValidationHelper.ensureExists("factory", "test hash code method", factory);
        this.testHashCodesEqual(factory);
        this.testHashCodeConsistent(factory);
    }

    public void testHashCodeMethod(Class<?> clazz) throws IllegalArgumentException, AssertionError {
        ValidationHelper.ensureExists("clazz", "test hash code method", clazz);
        Configuration configuration = this.configurationProvider.apply(clazz);
        BeanInformation beanInformation = this.beanInformationFactory.create(clazz);
        EquivalentPopulatedBeanFactory factory = new EquivalentPopulatedBeanFactory(beanInformation, this.getFactoryLookupStrategy(), configuration);
        this.testHashCodeMethod(factory);
    }

    protected void testHashCodesEqual(EquivalentFactory<?> factory) throws IllegalArgumentException, AssertionError {
        ValidationHelper.ensureExists("factory", "test hash codes equal for equal objects", factory);
        Object x = factory.create();
        Object y = factory.create();
        ValidationHelper.ensureExists("factory-created object", "test hash codes equal for equal objects", x);
        ValidationHelper.ensureExists("factory-created object", "test hash codes equal for equal objects", y);
        if (!x.equals(y)) {
            String message = "Cannot test hash codes equal for equal objects if objects that should be equal are not considered logically equivalent.";
            throw new IllegalArgumentException(message);
        }
        if (x.equals(y) && x.hashCode() != y.hashCode()) {
            AssertionUtils.fail("hashCodes are not the same for equal objects.");
        }
    }

    protected void testHashCodeConsistent(EquivalentFactory<?> factory) throws IllegalArgumentException, AssertionError {
        ValidationHelper.ensureExists("factory", "test hash code consistent item", factory);
        Object x = factory.create();
        ValidationHelper.ensureExists("factory-created object", "test hash code consistent item", x);
        int hashCode = x.hashCode();
        for (int idx = 0; idx < 100; ++idx) {
            if (x.hashCode() == hashCode) continue;
            AssertionUtils.fail("hashCode is not consistent on invocation [" + idx + "].");
        }
    }

    public RandomValueGenerator getRandomValueGenerator() {
        return this.randomValueGenerator;
    }

    public FactoryCollection getFactoryCollection() {
        return this.factoryCollection;
    }

    public FactoryLookupStrategy getFactoryLookupStrategy() {
        return this.factoryLookupStrategy;
    }
}

