/*
 * Decompiled with CFR 0.152.
 */
package org.meanbean.test;

import java.util.function.Supplier;
import org.meanbean.test.ObjectPropertyEqualityConsistentAsserter;
import org.meanbean.test.SignificantObjectPropertyEqualityConsistentAsserter;
import org.meanbean.test.internal.$EqualsBuilder;
import org.meanbean.util.AssertionUtils;
import org.meanbean.util.ValidationHelper;

class InsignificantObjectPropertyEqualityConsistentAsserter
implements ObjectPropertyEqualityConsistentAsserter {
    InsignificantObjectPropertyEqualityConsistentAsserter() {
    }

    @Override
    public void assertConsistent(String propertyName, Object originalObject, Object modifiedObject, Object originalPropertyValue, Object newPropertyValue) throws IllegalArgumentException, AssertionError {
        ValidationHelper.ensureExists("propertyName", "assert consistency of equals", propertyName);
        ValidationHelper.ensureExists("originalObject", "assert consistency of equals", originalObject);
        ValidationHelper.ensureExists("modifiedObject", "assert consistency of equals", modifiedObject);
        ValidationHelper.ensureExists("originalPropertyValue", "assert consistency of equals", originalPropertyValue);
        ValidationHelper.ensureExists("newPropertyValue", "assert consistency of equals", newPropertyValue);
        boolean newPropertyValueEqualsOriginalPropertyValue = $EqualsBuilder.objectsEqual(newPropertyValue, originalPropertyValue);
        boolean originalObjectEqualsModifiedObject = $EqualsBuilder.objectsEqual(originalObject, modifiedObject);
        Supplier<String> variableString = SignificantObjectPropertyEqualityConsistentAsserter.formatVariableString(propertyName, originalPropertyValue, newPropertyValue);
        if (!originalObjectEqualsModifiedObject && !newPropertyValueEqualsOriginalPropertyValue) {
            String message = "objects that differ due to supposedly insignificant property [" + propertyName + "] where considered unequal. " + variableString.get() + ". is property [" + propertyName + "] actually significant?";
            AssertionUtils.fail(message);
        } else if (!originalObjectEqualsModifiedObject && newPropertyValueEqualsOriginalPropertyValue) {
            String message = "objects that should be equal were considered unequal when testing insignificant property [" + propertyName + "]. " + variableString.get() + ". is equals incorrect?";
            AssertionUtils.fail(message);
        }
    }
}

