/*
 * Decompiled with CFR 0.152.
 */
package org.meanbean.util;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class ClassPath {
    private static final Logger logger = Logger.getLogger(ClassPath.class.getName());
    private static final Predicate<ClassInfo> IS_TOP_LEVEL = info -> ((ClassInfo)info).className.indexOf(36) == -1;
    private static final String CLASS_FILE_NAME_EXTENSION = ".class";
    private final Set<ResourceInfo> resources;

    private ClassPath(Set<ResourceInfo> resources) {
        this.resources = resources;
    }

    public static ClassPath from(ClassLoader classloader) throws IOException {
        DefaultScanner scanner = new DefaultScanner();
        scanner.scan(classloader);
        return new ClassPath(scanner.getResources());
    }

    public static ClassPath from(Class<?> clazz) {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                classLoader = clazz.getClassLoader();
            }
            return ClassPath.from(classLoader);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Set<ResourceInfo> getResources() {
        return this.resources;
    }

    public Set<ClassInfo> getAllClasses() {
        return this.filterResources(x -> true);
    }

    public Set<ClassInfo> getTopLevelClasses() {
        return this.filterResources(IS_TOP_LEVEL);
    }

    private Set<ClassInfo> filterResources(Predicate<ClassInfo> moreFilter) {
        Set set = this.resources.stream().filter(resource -> resource instanceof ClassInfo).map(resource -> (ClassInfo)resource).filter(moreFilter).collect(Collectors.toCollection(LinkedHashSet::new));
        return Collections.unmodifiableSet(set);
    }

    public Set<ClassInfo> getTopLevelClasses(String packageName) {
        ClassPath.checkNotNull(packageName);
        LinkedHashSet<ClassInfo> set = new LinkedHashSet<ClassInfo>();
        for (ClassInfo classInfo : this.getTopLevelClasses()) {
            if (!classInfo.getPackageName().equals(packageName)) continue;
            set.add(classInfo);
        }
        return Collections.unmodifiableSet(set);
    }

    public Set<ClassInfo> getTopLevelClassesRecursive(String packageName) {
        ClassPath.checkNotNull(packageName);
        String packagePrefix = packageName + '.';
        LinkedHashSet<ClassInfo> set = new LinkedHashSet<ClassInfo>();
        for (ClassInfo classInfo : this.getTopLevelClasses()) {
            if (!classInfo.getName().startsWith(packagePrefix)) continue;
            set.add(classInfo);
        }
        return Collections.unmodifiableSet(set);
    }

    static String getClassName(String filename) {
        int classNameEnd = filename.length() - CLASS_FILE_NAME_EXTENSION.length();
        return filename.substring(0, classNameEnd).replace('/', '.');
    }

    static File toFile(URL url) {
        if (!url.getProtocol().equals("file")) {
            throw new IllegalArgumentException();
        }
        try {
            return new File(url.toURI());
        }
        catch (URISyntaxException e) {
            return new File(url.getPath());
        }
    }

    static <T> T checkNotNull(T reference) {
        if (reference == null) {
            throw new NullPointerException();
        }
        return reference;
    }

    static final class DefaultScanner
    extends Scanner {
        private final Map<ClassLoader, LinkedHashSet<String>> resources = new LinkedHashMap<ClassLoader, LinkedHashSet<String>>();

        DefaultScanner() {
        }

        Set<ResourceInfo> getResources() {
            LinkedHashSet<ResourceInfo> set = new LinkedHashSet<ResourceInfo>();
            for (Map.Entry<ClassLoader, LinkedHashSet<String>> entry : this.resources.entrySet()) {
                for (String stringValue : entry.getValue()) {
                    set.add(ResourceInfo.of(stringValue, entry.getKey()));
                }
            }
            return Collections.unmodifiableSet(set);
        }

        @Override
        protected void scanJarFile(ClassLoader classloader, JarFile file) {
            Enumeration<JarEntry> entries = file.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (entry.isDirectory() || entry.getName().equals("META-INF/MANIFEST.MF")) continue;
                this.resourcesGet(classloader).add(entry.getName());
            }
        }

        private LinkedHashSet<String> resourcesGet(ClassLoader classloader) {
            this.resources.computeIfAbsent(classloader, key -> new LinkedHashSet());
            return this.resources.get(classloader);
        }

        @Override
        protected void scanDirectory(ClassLoader classloader, File directory) throws IOException {
            HashSet<File> currentPath = new HashSet<File>();
            currentPath.add(directory.getCanonicalFile());
            this.scanDirectory(directory, classloader, "", currentPath);
        }

        private void scanDirectory(File directory, ClassLoader classloader, String packagePrefix, Set<File> currentPath) throws IOException {
            File[] files = directory.listFiles();
            if (files == null) {
                logger.warning("Cannot read directory " + directory);
                return;
            }
            for (File f : files) {
                String name = f.getName();
                if (f.isDirectory()) {
                    File deref = f.getCanonicalFile();
                    if (!currentPath.add(deref)) continue;
                    this.scanDirectory(deref, classloader, packagePrefix + name + "/", currentPath);
                    currentPath.remove(deref);
                    continue;
                }
                String resourceName = packagePrefix + name;
                if (resourceName.equals("META-INF/MANIFEST.MF")) continue;
                this.resourcesGet(classloader).add(resourceName);
            }
        }
    }

    static abstract class Scanner {
        private final Set<File> scannedUris = new HashSet<File>();

        Scanner() {
        }

        public final void scan(ClassLoader classloader) throws IOException {
            for (Map.Entry<File, ClassLoader> entry : Scanner.getClassPathEntries(classloader).entrySet()) {
                this.scan(entry.getKey(), entry.getValue());
            }
        }

        final void scan(File file, ClassLoader classloader) throws IOException {
            if (this.scannedUris.add(file.getCanonicalFile())) {
                this.scanFrom(file, classloader);
            }
        }

        protected abstract void scanDirectory(ClassLoader var1, File var2) throws IOException;

        protected abstract void scanJarFile(ClassLoader var1, JarFile var2) throws IOException;

        private void scanFrom(File file, ClassLoader classloader) throws IOException {
            try {
                if (!file.exists()) {
                    return;
                }
            }
            catch (SecurityException e) {
                logger.warning("Cannot access " + file + ": " + e);
                return;
            }
            if (file.isDirectory()) {
                this.scanDirectory(classloader, file);
            } else {
                this.scanJar(file, classloader);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void scanJar(File file, ClassLoader classloader) throws IOException {
            JarFile jarFile;
            try {
                jarFile = new JarFile(file);
            }
            catch (IOException e) {
                return;
            }
            try {
                for (File path : Scanner.getClassPathFromManifest(file, jarFile.getManifest())) {
                    this.scan(path, classloader);
                }
                this.scanJarFile(classloader, jarFile);
            }
            finally {
                try {
                    jarFile.close();
                }
                catch (IOException iOException) {}
            }
        }

        static Set<File> getClassPathFromManifest(File jarFile, Manifest manifest) {
            if (manifest == null) {
                return Collections.emptySet();
            }
            LinkedHashSet<File> set = new LinkedHashSet<File>();
            String classpathAttribute = manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH.toString());
            if (classpathAttribute != null) {
                for (String path : Scanner.splitClassPathAttributes(classpathAttribute)) {
                    URL url;
                    try {
                        url = Scanner.getClassPathEntry(jarFile, path);
                    }
                    catch (MalformedURLException e) {
                        logger.warning("Invalid Class-Path entry: " + path);
                        continue;
                    }
                    if (!url.getProtocol().equals("file")) continue;
                    set.add(ClassPath.toFile(url));
                }
            }
            return Collections.unmodifiableSet(set);
        }

        private static List<String> splitClassPathAttributes(String value) {
            return Stream.of(value.split(" ")).filter(token -> token != null && !token.isEmpty()).collect(Collectors.toList());
        }

        static Map<File, ClassLoader> getClassPathEntries(ClassLoader classloader) {
            LinkedHashMap<File, ClassLoader> entries = new LinkedHashMap<File, ClassLoader>();
            ClassLoader parent = classloader.getParent();
            if (parent != null) {
                entries.putAll(Scanner.getClassPathEntries(parent));
            }
            for (URL url : Scanner.getClassLoaderUrls(classloader)) {
                File file;
                if (!url.getProtocol().equals("file") || entries.containsKey(file = ClassPath.toFile(url))) continue;
                entries.put(file, classloader);
            }
            return Collections.unmodifiableMap(entries);
        }

        private static List<URL> getClassLoaderUrls(ClassLoader classloader) {
            if (classloader instanceof URLClassLoader) {
                URL[] urLs = ((URLClassLoader)classloader).getURLs();
                return Collections.unmodifiableList(Arrays.asList(urLs));
            }
            if (classloader.equals(ClassLoader.getSystemClassLoader())) {
                return Scanner.parseJavaClassPath();
            }
            return Collections.emptyList();
        }

        static List<URL> parseJavaClassPath() {
            ArrayList<URL> urls = new ArrayList<URL>();
            for (String entry : Scanner.javaClassPath().split(Scanner.pathSeparator())) {
                try {
                    try {
                        urls.add(new File(entry).toURI().toURL());
                    }
                    catch (SecurityException e) {
                        urls.add(new URL("file", null, new File(entry).getAbsolutePath()));
                    }
                }
                catch (MalformedURLException e) {
                    logger.log(Level.WARNING, "malformed classpath entry: " + entry, e);
                }
            }
            return Collections.unmodifiableList(urls);
        }

        private static String javaClassPath() {
            return System.getProperty("java.class.path");
        }

        private static String pathSeparator() {
            return System.getProperty("path.separator");
        }

        static URL getClassPathEntry(File jarFile, String path) throws MalformedURLException {
            return new URL(jarFile.toURI().toURL(), path);
        }
    }

    public static final class ClassInfo
    extends ResourceInfo {
        private final String className;

        ClassInfo(String resourceName, ClassLoader loader) {
            super(resourceName, loader);
            this.className = ClassPath.getClassName(resourceName);
        }

        public String getPackageName() {
            int lastDot = this.className.lastIndexOf(46);
            return lastDot < 0 ? "" : this.className.substring(0, lastDot);
        }

        public String getSimpleName() {
            int lastDollarSign = this.className.lastIndexOf(36);
            if (lastDollarSign != -1) {
                String innerClassName = this.className.substring(lastDollarSign + 1);
                return this.trimLeadingFrom(innerClassName, val -> 48 <= val && val <= 57);
            }
            String packageName = this.getPackageName();
            if (packageName.isEmpty()) {
                return this.className;
            }
            return this.className.substring(packageName.length() + 1);
        }

        private String trimLeadingFrom(String input, IntPredicate predicate) {
            int index = 0;
            for (index = 0; index < input.length() && predicate.test(input.charAt(0)); ++index) {
            }
            StringBuilder sb = new StringBuilder();
            while (index < input.length()) {
                sb.append(input.charAt(index));
                ++index;
            }
            return sb.toString();
        }

        public String getName() {
            return this.className;
        }

        public Class<?> load() {
            try {
                return this.loader.loadClass(this.className);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public String toString() {
            return this.className;
        }
    }

    public static class ResourceInfo {
        private final String resourceName;
        final ClassLoader loader;

        static ResourceInfo of(String resourceName, ClassLoader loader) {
            if (resourceName.endsWith(ClassPath.CLASS_FILE_NAME_EXTENSION)) {
                return new ClassInfo(resourceName, loader);
            }
            return new ResourceInfo(resourceName, loader);
        }

        ResourceInfo(String resourceName, ClassLoader loader) {
            this.resourceName = ClassPath.checkNotNull(resourceName);
            this.loader = ClassPath.checkNotNull(loader);
        }

        public final URL url() {
            URL url = this.loader.getResource(this.resourceName);
            if (url == null) {
                throw new NoSuchElementException(this.resourceName);
            }
            return url;
        }

        public final String getResourceName() {
            return this.resourceName;
        }

        public int hashCode() {
            return this.resourceName.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof ResourceInfo) {
                ResourceInfo that = (ResourceInfo)obj;
                return this.resourceName.equals(that.resourceName) && this.loader == that.loader;
            }
            return false;
        }

        public String toString() {
            return this.resourceName;
        }
    }
}

