/*
 * Decompiled with CFR 0.152.
 */
package org.meanbean.util;

import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.meanbean.util.Order;
import org.meanbean.util.ServiceDefinition;
import org.meanbean.util.ServiceLoader;
import org.meanbean.util.ValidationHelper;

public class ServiceFactory<T> {
    private static final ServiceContextMap serviceContextMap = new ServiceContextMap();
    private final List<T> services;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized <T> ServiceFactory<T> getInstance(ServiceDefinition<T> definition) {
        String inprogressKey = "Load of " + definition.getServiceType().getName() + " already in progress";
        Map<String, Object> contextMap = serviceContextMap.getContextMap();
        if (contextMap.containsKey(inprogressKey)) {
            throw new IllegalStateException(inprogressKey);
        }
        contextMap.put(inprogressKey, inprogressKey);
        try {
            ServiceFactory serviceFactory = (ServiceFactory)contextMap.computeIfAbsent(definition.getServiceType().getName(), key -> ServiceFactory.create(definition));
            return serviceFactory;
        }
        finally {
            contextMap.remove(inprogressKey);
        }
    }

    public static Void createContext(Object key) {
        serviceContextMap.createContext(key);
        return null;
    }

    public static Void createContextIfNeeded(Object key) {
        serviceContextMap.createContextIfNeeded(key);
        return null;
    }

    public static boolean hasContext() {
        return serviceContextMap.hasContext();
    }

    public static void clear() {
        serviceContextMap.clear();
    }

    static <T> ServiceFactory<T> create(ServiceDefinition<T> definition) {
        List<T> services = ServiceFactory.doLoad(definition);
        return new ServiceFactory<T>(services, definition);
    }

    private ServiceFactory(List<T> services, ServiceDefinition<T> definition) {
        if (services.isEmpty()) {
            throw new IllegalArgumentException("cannot find services for " + definition.getServiceType());
        }
        this.services = Collections.unmodifiableList(services);
    }

    public T getFirst() {
        return this.getAll().get(0);
    }

    public List<T> getAll() {
        return this.services;
    }

    private static synchronized <T> List<T> doLoad(ServiceDefinition<T> serviceDefinition) {
        ServiceLoader<T> loader = new ServiceLoader<T>(serviceDefinition.getServiceType(), serviceDefinition.getConstructorTypes());
        List<T> services = loader.createAll(serviceDefinition.getConstructorArgs());
        Collections.sort(services, ServiceFactory.getComparator());
        return services;
    }

    public static <T> Comparator<T> getComparator() {
        return Comparator.comparingInt(ServiceFactory::getOrder);
    }

    private static <T> int getOrder(T obj) {
        Order order = obj.getClass().getAnnotation(Order.class);
        if (order == null) {
            return Integer.MAX_VALUE;
        }
        return order.value();
    }

    private static class ServiceContextMap {
        private static final ThreadLocal<WeakReference<Object>> currentKey = new ThreadLocal();
        private final Map<Object, Map<String, Object>> contextMapByKeys = new WeakHashMap<Object, Map<String, Object>>();
        private final Set<Class<?>> keyTypes = Collections.newSetFromMap(new ConcurrentHashMap());

        private ServiceContextMap() {
        }

        public synchronized Map<String, Object> getContextMap() {
            WeakReference<Object> ref = currentKey.get();
            Objects.requireNonNull(ref, "context key not set");
            Object key = ref.get();
            Objects.requireNonNull(key, "context key not available");
            return this.contextMapByKeys.computeIfAbsent(key, any -> new ConcurrentHashMap());
        }

        public boolean hasContext() {
            WeakReference<Object> ref = currentKey.get();
            return ref != null && ref.get() != null;
        }

        public synchronized void clear() {
            this.contextMapByKeys.clear();
            this.keyTypes.clear();
            currentKey.remove();
        }

        public void createContext(Object key) {
            this.verifyIdentityEquals(key);
            currentKey.set(new WeakReference<Object>(key));
        }

        public void createContextIfNeeded(Object key) {
            if (!this.hasContext()) {
                this.createContext(key);
            }
        }

        private void verifyIdentityEquals(Object obj) {
            if (this.keyTypes.contains(obj.getClass())) {
                return;
            }
            if (!obj.getClass().equals(Object.class)) {
                try {
                    Method method = obj.getClass().getMethod("equals", Object.class);
                    ValidationHelper.ensure(method.getDeclaringClass().equals(Object.class), "unexpected declaration class for " + method);
                    method = obj.getClass().getMethod("hashCode", new Class[0]);
                    ValidationHelper.ensure(method.getDeclaringClass().equals(Object.class), "unexpected declaration class for " + method);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            this.keyTypes.add(obj.getClass());
        }
    }
}

