/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import oshi.software.os.OSProcess;
import oshi.software.os.OperatingSystem;
import oshi.software.os.OperatingSystemVersion;

public abstract class AbstractOperatingSystem
implements OperatingSystem {
    private static final long serialVersionUID = 1L;
    protected String manufacturer;
    protected String family;
    protected OperatingSystemVersion version;
    private static final Comparator<OSProcess> CPU_DESC_SORT = (p1, p2) -> Double.compare((double)(p2.getKernelTime() + p2.getUserTime()) / (double)p2.getUpTime(), (double)(p1.getKernelTime() + p1.getUserTime()) / (double)p1.getUpTime());
    private static final Comparator<OSProcess> RSS_DESC_SORT = (p1, p2) -> Long.compare(p2.getResidentSetSize(), p1.getResidentSetSize());
    private static final Comparator<OSProcess> UPTIME_DESC_SORT = (p1, p2) -> Long.compare(p2.getUpTime(), p1.getUpTime());
    private static final Comparator<OSProcess> UPTIME_ASC_SORT = (p1, p2) -> Long.compare(p1.getUpTime(), p2.getUpTime());
    private static final Comparator<OSProcess> PID_ASC_SORT = (p1, p2) -> Integer.compare(p1.getProcessID(), p2.getProcessID());
    private static final Comparator<OSProcess> PARENTPID_ASC_SORT = (p1, p2) -> Integer.compare(p1.getParentProcessID(), p2.getParentProcessID());
    private static final Comparator<OSProcess> NAME_ASC_SORT = (p1, p2) -> p1.getName().toLowerCase().compareTo(p2.getName().toLowerCase());

    @Override
    public OperatingSystemVersion getVersion() {
        return this.version;
    }

    @Override
    public String getFamily() {
        return this.family;
    }

    @Override
    public String getManufacturer() {
        return this.manufacturer;
    }

    protected List<OSProcess> processSort(List<OSProcess> processes, int limit, OperatingSystem.ProcessSort sort) {
        if (sort != null) {
            switch (sort) {
                case CPU: {
                    Collections.sort(processes, CPU_DESC_SORT);
                    break;
                }
                case MEMORY: {
                    Collections.sort(processes, RSS_DESC_SORT);
                    break;
                }
                case OLDEST: {
                    Collections.sort(processes, UPTIME_DESC_SORT);
                    break;
                }
                case NEWEST: {
                    Collections.sort(processes, UPTIME_ASC_SORT);
                    break;
                }
                case PID: {
                    Collections.sort(processes, PID_ASC_SORT);
                    break;
                }
                case PARENTPID: {
                    Collections.sort(processes, PARENTPID_ASC_SORT);
                    break;
                }
                case NAME: {
                    Collections.sort(processes, NAME_ASC_SORT);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unimplemented enum type: " + sort.toString());
                }
            }
        }
        int maxProcs = processes.size();
        if (limit > 0 && maxProcs > limit) {
            maxProcs = limit;
        }
        ArrayList<OSProcess> procs = new ArrayList<OSProcess>();
        for (int i = 0; i < maxProcs; ++i) {
            procs.add(processes.get(i));
        }
        return procs;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getManufacturer()).append(' ').append(this.getFamily()).append(' ').append(this.getVersion().toString());
        return sb.toString();
    }
}

