/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.linux;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.software.os.FileSystem;
import oshi.software.os.OSFileStore;
import oshi.util.FileUtil;
import oshi.util.ParseUtil;

public class LinuxFileSystem
implements FileSystem {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(LinuxFileSystem.class);
    private final List<String> pseudofs = Arrays.asList("rootfs", "sysfs", "proc", "devtmpfs", "devpts", "securityfs", "cgroup", "pstore", "hugetlbfs", "configfs", "selinuxfs", "systemd-1", "binfmt_misc", "mqueue", "debugfs", "nfsd", "sunrpc", "rpc_pipefs", "fusectl");
    private final List<String> tmpfsPaths = Arrays.asList("/dev/shm", "/run", "/sys", "/proc");

    private boolean listElementStartsWith(List<String> aList, String charSeq) {
        for (String match : aList) {
            if (!charSeq.equals(match) && !charSeq.startsWith(match + "/")) continue;
            return true;
        }
        return false;
    }

    @Override
    public OSFileStore[] getFileStores() {
        HashMap<String, String> uuidMap = new HashMap<String, String>();
        File uuidDir = new File("/dev/disk/by-uuid");
        if (uuidDir != null && uuidDir.listFiles() != null) {
            for (File uuid : uuidDir.listFiles()) {
                try {
                    uuidMap.put(uuid.getCanonicalPath(), uuid.getName().toLowerCase());
                }
                catch (IOException e) {
                    LOG.error("Couldn't get canonical path for {}. {}", (Object)uuid.getName(), (Object)e);
                }
            }
        }
        ArrayList<OSFileStore> fsList = new ArrayList<OSFileStore>();
        List<String> mounts = FileUtil.readFile("/proc/self/mounts");
        for (String mount : mounts) {
            String[] split = mount.split(" ");
            if (split.length < 6) continue;
            String path = split[1].replaceAll("\\\\040", " ");
            String type = split[2];
            if (this.pseudofs.contains(type) || path.equals("/dev") || this.listElementStartsWith(this.tmpfsPaths, path)) continue;
            String name = split[0].replaceAll("\\\\040", " ");
            if (path.equals("/")) {
                name = "/";
            }
            String volume = split[0].replaceAll("\\\\040", " ");
            String uuid = uuidMap.getOrDefault(split[0], "");
            long totalSpace = new File(path).getTotalSpace();
            long usableSpace = new File(path).getUsableSpace();
            String description = volume.startsWith("/dev") ? "Local Disk" : (volume.equals("tmpfs") ? "Ram Disk" : (type.startsWith("nfs") || type.equals("cifs") ? "Network Disk" : "Mount Point"));
            OSFileStore osStore = new OSFileStore(name, volume, path, description, type, uuid, usableSpace, totalSpace);
            fsList.add(osStore);
        }
        return fsList.toArray(new OSFileStore[fsList.size()]);
    }

    @Override
    public long getOpenFileDescriptors() {
        return this.getFileDescriptors(0);
    }

    @Override
    public long getMaxFileDescriptors() {
        return this.getFileDescriptors(2);
    }

    private long getFileDescriptors(int index) {
        String filename = "/proc/sys/fs/file-nr";
        if (index < 0 || index > 2) {
            throw new IllegalArgumentException("Index must be between 0 and 2.");
        }
        List<String> osDescriptors = FileUtil.readFile(filename);
        if (!osDescriptors.isEmpty()) {
            String[] splittedLine = osDescriptors.get(0).split("\\D+");
            return ParseUtil.parseLongOrDefault(splittedLine[index], 0L);
        }
        return 0L;
    }
}

