/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.unix.solaris;

import java.util.ArrayList;
import java.util.List;
import oshi.jna.platform.linux.Libc;
import oshi.software.common.AbstractOperatingSystem;
import oshi.software.os.FileSystem;
import oshi.software.os.NetworkParams;
import oshi.software.os.OSProcess;
import oshi.software.os.OperatingSystem;
import oshi.software.os.unix.solaris.SolarisFileSystem;
import oshi.software.os.unix.solaris.SolarisNetworkParams;
import oshi.software.os.unix.solaris.SolarisOSVersionInfoEx;
import oshi.util.ExecutingCommand;
import oshi.util.ParseUtil;
import oshi.util.platform.linux.ProcUtil;

public class SolarisOperatingSystem
extends AbstractOperatingSystem {
    private static final long serialVersionUID = 1L;

    public SolarisOperatingSystem() {
        this.manufacturer = "Oracle";
        this.family = "SunOS";
        this.version = new SolarisOSVersionInfoEx();
    }

    @Override
    public FileSystem getFileSystem() {
        return new SolarisFileSystem();
    }

    @Override
    public OSProcess[] getProcesses(int limit, OperatingSystem.ProcessSort sort) {
        List<OSProcess> procs = this.getProcessListFromPS("ps -eo s,pid,ppid,user,uid,group,gid,nlwp,pri,vsz,rss,etime,time,comm,args");
        List<OSProcess> sorted = this.processSort(procs, limit, sort);
        return sorted.toArray(new OSProcess[sorted.size()]);
    }

    @Override
    public OSProcess getProcess(int pid) {
        List<OSProcess> procs = this.getProcessListFromPS("ps -o s,pid,ppid,user,uid,group,gid,nlwp,pri,vsz,rss,etime,time,comm,args -p " + pid);
        if (procs.isEmpty()) {
            return null;
        }
        return procs.get(0);
    }

    private List<OSProcess> getProcessListFromPS(String psCommand) {
        ArrayList<OSProcess> procs = new ArrayList<OSProcess>();
        List<String> procList = ExecutingCommand.runNative(psCommand);
        if (procList.isEmpty() || procList.size() < 2) {
            return procs;
        }
        procList.remove(0);
        for (String proc : procList) {
            String[] split = proc.trim().split("\\s+", 15);
            if (split.length < 15) continue;
            long now = System.currentTimeMillis();
            OSProcess sproc = new OSProcess();
            switch (split[0].charAt(0)) {
                case 'O': {
                    sproc.setState(OSProcess.State.RUNNING);
                    break;
                }
                case 'S': {
                    sproc.setState(OSProcess.State.SLEEPING);
                    break;
                }
                case 'R': 
                case 'W': {
                    sproc.setState(OSProcess.State.WAITING);
                    break;
                }
                case 'Z': {
                    sproc.setState(OSProcess.State.ZOMBIE);
                    break;
                }
                case 'T': {
                    sproc.setState(OSProcess.State.STOPPED);
                    break;
                }
                default: {
                    sproc.setState(OSProcess.State.OTHER);
                }
            }
            sproc.setProcessID(ParseUtil.parseIntOrDefault(split[1], 0));
            sproc.setParentProcessID(ParseUtil.parseIntOrDefault(split[2], 0));
            sproc.setUser(split[3]);
            sproc.setUserID(split[4]);
            sproc.setGroup(split[5]);
            sproc.setGroupID(split[6]);
            sproc.setThreadCount(ParseUtil.parseIntOrDefault(split[7], 0));
            sproc.setPriority(ParseUtil.parseIntOrDefault(split[8], 0));
            sproc.setVirtualSize(ParseUtil.parseLongOrDefault(split[9], 0L) * 1024L);
            sproc.setResidentSetSize(ParseUtil.parseLongOrDefault(split[10], 0L) * 1024L);
            long elapsedTime = ParseUtil.parseDHMSOrDefault(split[11], 0L);
            sproc.setUpTime(elapsedTime < 1L ? 1L : elapsedTime);
            sproc.setStartTime(now - sproc.getUpTime());
            sproc.setUserTime(ParseUtil.parseDHMSOrDefault(split[12], 0L));
            sproc.setPath(split[13]);
            sproc.setName(sproc.getPath().substring(sproc.getPath().lastIndexOf(47) + 1));
            sproc.setCommandLine(split[14]);
            procs.add(sproc);
        }
        return procs;
    }

    @Override
    public int getProcessId() {
        return Libc.INSTANCE.getpid();
    }

    @Override
    public int getProcessCount() {
        return ProcUtil.getPidFiles().length;
    }

    @Override
    public int getThreadCount() {
        List<String> threadList = ExecutingCommand.runNative("ps -eLo pid");
        if (!threadList.isEmpty()) {
            return threadList.size() - 1;
        }
        return this.getProcessCount();
    }

    @Override
    public NetworkParams getNetworkParams() {
        return new SolarisNetworkParams();
    }
}

