/*
 * Decompiled with CFR 0.152.
 */
package com.github.reinert.jjschema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.github.reinert.jjschema.Attributes;
import com.github.reinert.jjschema.JsonSchemaGenerator;
import com.github.reinert.jjschema.Media;
import com.github.reinert.jjschema.Rel;
import com.github.reinert.jjschema.exception.InvalidLinkMethod;
import com.github.reinert.jjschema.exception.TypeException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.Collection;
import java.util.Iterator;
import javax.ws.rs.CookieParam;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;

public class HyperSchemaGeneratorV4
extends JsonSchemaGenerator {
    private static final String BINARY_ENCODING = "binaryEncoding";
    private static final String MEDIA_TYPE = "mediaType";
    final JsonSchemaGenerator jsonSchemaGenerator;

    protected HyperSchemaGeneratorV4(JsonSchemaGenerator jsonSchemaGenerator) {
        this.jsonSchemaGenerator = jsonSchemaGenerator;
    }

    private ObjectNode generateLink(Method method) throws InvalidLinkMethod, TypeException {
        Class<?>[] paramTypes;
        Annotation[] ans;
        String href = null;
        String rel = null;
        String httpMethod = null;
        boolean isLink = false;
        for (Annotation a : ans = method.getAnnotations()) {
            if (a.annotationType().equals(GET.class)) {
                httpMethod = "GET";
                isLink = true;
                continue;
            }
            if (a.annotationType().equals(POST.class)) {
                httpMethod = "POST";
                isLink = true;
                continue;
            }
            if (a.annotationType().equals(PUT.class)) {
                httpMethod = "PUT";
                isLink = true;
                continue;
            }
            if (a.annotationType().equals(DELETE.class)) {
                httpMethod = "DELETE";
                isLink = true;
                continue;
            }
            if (a.annotationType().equals(HEAD.class)) {
                throw new RuntimeException("HEAD not yet supported.");
            }
            if (a.annotationType().equals(Path.class)) {
                Path p = (Path)a;
                href = p.value();
                continue;
            }
            if (!a.annotationType().equals(Rel.class)) continue;
            Rel l = (Rel)a;
            rel = l.value();
        }
        if (!isLink) {
            throw new InvalidLinkMethod("Method " + method.getName() + " is not a link. Must use a HTTP METHOD annotation.");
        }
        if (rel == null) {
            rel = method.getName();
        }
        if (href == null) {
            href = "#";
        }
        ObjectNode link = this.jsonSchemaGenerator.createInstance();
        link.put("href", href);
        link.put("method", httpMethod);
        link.put("rel", rel);
        ObjectNode tgtSchema = this.generateSchema(method.getReturnType());
        if (tgtSchema != null) {
            link.put("targetSchema", (JsonNode)tgtSchema);
        }
        if ((paramTypes = method.getParameterTypes()).length > 0) {
            ObjectNode schema = null;
            boolean hasParam = false;
            boolean hasBodyParam = false;
            for (int i = 0; i < paramTypes.length; ++i) {
                Annotation[] paramAns = method.getParameterAnnotations()[i];
                Media media = null;
                String prop = null;
                boolean isBodyParam = true;
                boolean isParam = false;
                for (int j = 0; j < paramAns.length; ++j) {
                    Annotation a2;
                    Annotation a = paramAns[j];
                    if (a instanceof QueryParam) {
                        if (schema == null) {
                            schema = this.jsonSchemaGenerator.createInstance();
                            schema.put("type", "object");
                        }
                        QueryParam q = (QueryParam)a;
                        schema.put(q.value(), (JsonNode)this.jsonSchemaGenerator.generateSchema(paramTypes[i]));
                        prop = q.value();
                        hasParam = true;
                        isBodyParam = false;
                        isParam = true;
                        continue;
                    }
                    if (a instanceof FormParam) {
                        if (schema == null) {
                            schema = this.jsonSchemaGenerator.createInstance();
                            schema.put("type", "object");
                        }
                        FormParam q = (FormParam)a;
                        schema.put(q.value(), (JsonNode)this.jsonSchemaGenerator.generateSchema(paramTypes[i]));
                        prop = q.value();
                        hasParam = true;
                        isBodyParam = false;
                        isParam = true;
                        continue;
                    }
                    if (a instanceof PathParam) {
                        if (media != null) {
                            throw new RuntimeException("Media cannot be declared along with PathParam.");
                        }
                        for (int k = j + 1; k < paramAns.length; ++k) {
                            a2 = paramAns[k];
                            if (!(a2 instanceof Media)) continue;
                            throw new RuntimeException("Media cannot be declared along with PathParam.");
                        }
                        isBodyParam = false;
                        continue;
                    }
                    if (a instanceof CookieParam) {
                        if (media != null) {
                            media = null;
                        }
                        isBodyParam = false;
                        continue;
                    }
                    if (a instanceof HeaderParam) {
                        if (media != null) {
                            media = null;
                        }
                        isBodyParam = false;
                        continue;
                    }
                    if (a instanceof MatrixParam) {
                        if (media != null) {
                            throw new RuntimeException("Media cannot be declared along with MatrixParam.");
                        }
                        for (int k = j + 1; k < paramAns.length; ++k) {
                            a2 = paramAns[k];
                            if (!(a2 instanceof Media)) continue;
                            throw new RuntimeException("Media cannot be declared along with MatrixParam.");
                        }
                        isBodyParam = false;
                        continue;
                    }
                    if (a instanceof Context) {
                        if (media != null) {
                            throw new RuntimeException("Media cannot be declared along with Context.");
                        }
                        isBodyParam = false;
                        continue;
                    }
                    if (!(a instanceof Media)) continue;
                    media = (Media)a;
                }
                if (isBodyParam) {
                    hasBodyParam = true;
                    schema = this.generateSchema(paramTypes[i]);
                    if (media == null) continue;
                    schema.put(MEDIA_TYPE, media.type());
                    schema.put(BINARY_ENCODING, media.binaryEncoding());
                    continue;
                }
                if (!isParam) continue;
                hasParam = true;
                if (media == null) continue;
                ObjectNode hs = (ObjectNode)schema.get(prop);
                hs.put(MEDIA_TYPE, media.type());
                hs.put(BINARY_ENCODING, media.binaryEncoding());
                schema.put(prop, (JsonNode)hs);
            }
            if (hasBodyParam && hasParam) {
                throw new RuntimeException("JsonSchema does not support both FormParam or QueryParam and BodyParam at the same time.");
            }
            link.put("schema", schema);
        }
        return link;
    }

    private <T> ObjectNode generateHyperSchemaFromResource(Class<T> type) throws TypeException {
        ObjectNode schema = null;
        Annotation[] ans = type.getAnnotations();
        boolean hasPath = false;
        for (Annotation a : ans) {
            Path p;
            if (a instanceof Path) {
                hasPath = true;
                p = (Path)a;
                if (schema == null) {
                    schema = this.jsonSchemaGenerator.createInstance();
                }
                schema.put("pathStart", p.value());
            }
            if (!(a instanceof Produces)) continue;
            p = (Produces)a;
            if (schema == null) {
                schema = this.jsonSchemaGenerator.createInstance();
            }
            schema.put(MEDIA_TYPE, p.value()[0]);
        }
        if (!hasPath) {
            throw new RuntimeException("Invalid Resource class. Must use Path annotation.");
        }
        ArrayNode links = schema.putArray("links");
        for (Method method : type.getDeclaredMethods()) {
            int modifiers = method.getModifiers();
            if (method.isSynthetic() || method.isBridge() || Modifier.isStatic(modifiers)) continue;
            try {
                ObjectNode link = this.generateLink(method);
                if ("GET".equals(link.get("method").asText()) && "#".equals(link.get("href").asText())) {
                    this.jsonSchemaGenerator.mergeSchema(schema, (ObjectNode)link.get("targetSchema"), true);
                    continue;
                }
                links.add((JsonNode)link);
            }
            catch (InvalidLinkMethod e) {
                e.printStackTrace();
            }
        }
        return schema;
    }

    private static <T> ObjectNode transformJsonToHyperSchema(Class<T> type, ObjectNode jsonSchema) {
        ObjectNode properties = (ObjectNode)jsonSchema.get("properties");
        Iterator namesIterator = properties.fieldNames();
        while (namesIterator.hasNext()) {
            String prop = (String)namesIterator.next();
            try {
                Field field = type.getDeclaredField(prop);
                Media media = field.getAnnotation(Media.class);
                if (media == null) continue;
                ObjectNode hyperProp = (ObjectNode)properties.get(prop);
                hyperProp.put(MEDIA_TYPE, media.type());
                hyperProp.put(BINARY_ENCODING, media.binaryEncoding());
                if (hyperProp.get("type").isArray()) {
                    TextNode typeString = new TextNode("string");
                    ((ArrayNode)hyperProp.get("type")).set(0, (JsonNode)typeString);
                } else {
                    hyperProp.put("type", "string");
                }
                properties.put(prop, (JsonNode)hyperProp);
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (SecurityException securityException) {}
        }
        return jsonSchema;
    }

    @Override
    public <T> ObjectNode generateSchema(Class<T> type) throws TypeException {
        ObjectNode hyperSchema = null;
        Path path = type.getAnnotation(Path.class);
        if (path != null) {
            hyperSchema = this.generateHyperSchemaFromResource(type);
        } else {
            ObjectNode jsonSchema = this.jsonSchemaGenerator.generateSchema(type);
            if (jsonSchema != null) {
                if ("array".equals(jsonSchema.get("type").asText())) {
                    if (!Collection.class.isAssignableFrom(type)) {
                        ObjectNode items = (ObjectNode)jsonSchema.get("items");
                        Field field = type.getDeclaredFields()[0];
                        ParameterizedType genericType = (ParameterizedType)field.getGenericType();
                        Class genericClass = (Class)genericType.getActualTypeArguments()[0];
                        ObjectNode hyperItems = HyperSchemaGeneratorV4.transformJsonToHyperSchema(genericClass, items);
                        jsonSchema.put("items", (JsonNode)hyperItems);
                    }
                    hyperSchema = jsonSchema;
                } else {
                    hyperSchema = jsonSchema.has("properties") ? HyperSchemaGeneratorV4.transformJsonToHyperSchema(type, jsonSchema) : jsonSchema;
                }
            }
        }
        return hyperSchema;
    }

    @Override
    protected void processSchemaProperty(ObjectNode schema, Attributes props) {
        this.jsonSchemaGenerator.processSchemaProperty(schema, props);
    }
}

