/*
 * Decompiled with CFR 0.152.
 */
package com.github.reinert.jjschema;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.AbstractCollection;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.UUID;

public enum SimpleTypeMappings {
    PRIMITIVE_BYTE(Byte.TYPE, "integer"),
    PRIMITIVE_SHORT(Short.TYPE, "integer"),
    PRIMITIVE_INTEGER(Integer.TYPE, "integer"),
    PRIMITIVE_LONG(Long.TYPE, "integer"),
    BYTE(Byte.class, "integer"),
    SHORT(Short.class, "integer"),
    INTEGER(Integer.class, "integer"),
    LONG(Long.class, "integer"),
    BIGINTEGER(BigInteger.class, "integer"),
    PRIMITIVE_FLOAT(Float.TYPE, "number"),
    PRIMITIVE_DOUBLE(Double.TYPE, "number"),
    FLOAT(Float.class, "number"),
    DOUBLE(Double.class, "number"),
    BIGDECIMAL(BigDecimal.class, "number"),
    PRIMITIVE_BOOLEAN(Boolean.TYPE, "boolean"),
    BOOLEAN(Boolean.class, "boolean"),
    PRIMITIVE_CHAR(Character.TYPE, "string"),
    CHAR(Character.class, "string"),
    CHARSEQUENCE(CharSequence.class, "string"),
    STRING(String.class, "string"),
    UUID(UUID.class, "string"),
    DATE(Date.class, "string"),
    ZONEDDATETIME(ZonedDateTime.class, "string"),
    LOCALDATE(LocalDate.class, "string"),
    LOCALTIME(LocalTime.class, "string"),
    LOCALDATETIME(LocalDateTime.class, "string"),
    INSTANT(Instant.class, "string"),
    ZONE_ID(ZoneId.class, "string"),
    OFFSETDATETIME(OffsetDateTime.class, "string");

    private static final Map<Class<?>, String> MAPPINGS;
    private final Class<?> c;
    private final String schemaType;

    private SimpleTypeMappings(Class<?> c, String schemaType) {
        this.c = c;
        this.schemaType = schemaType;
    }

    public static String forClass(Type type) {
        if (!(type instanceof Class)) {
            return null;
        }
        if (AbstractCollection.class.isAssignableFrom((Class)type)) {
            return "array";
        }
        return MAPPINGS.get(type);
    }

    public static boolean isSimpleType(Type type) {
        return SimpleTypeMappings.forClass(type) != null;
    }

    static {
        MAPPINGS = new IdentityHashMap();
        for (SimpleTypeMappings mapping : SimpleTypeMappings.values()) {
            MAPPINGS.put(mapping.c, mapping.schemaType);
        }
    }
}

