/*
 * Decompiled with CFR 0.152.
 */
package com.github.reinert.jjschema.v1;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.reinert.jjschema.Attributes;
import com.github.reinert.jjschema.JJSchemaUtil;
import com.github.reinert.jjschema.ManagedReference;
import com.github.reinert.jjschema.v1.PropertyWrapper;
import com.github.reinert.jjschema.v1.SchemaWrapper;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CustomSchemaWrapper
extends SchemaWrapper
implements Iterable<PropertyWrapper> {
    public static final String TAG_REQUIRED = "required";
    public static final String TAG_PROPERTIES = "properties";
    private final List<PropertyWrapper> propertyWrappers;
    private boolean required;
    private final Set<ManagedReference> managedReferences;
    private String relativeId = "#";

    public CustomSchemaWrapper(Type type) {
        this(type, false);
    }

    public CustomSchemaWrapper(Type type, boolean ignoreProperties) {
        this(type, new HashSet<ManagedReference>(), null, ignoreProperties);
    }

    public CustomSchemaWrapper(Type type, Set<ManagedReference> managedReferences, boolean ignoreProperties) {
        this(type, managedReferences, null, ignoreProperties);
    }

    public CustomSchemaWrapper(Type type, Set<ManagedReference> managedReferences, String relativeId, boolean ignoreProperties) {
        super(type);
        this.setType("object");
        this.processNullable();
        this.processAttributes(this.getNode(), type);
        this.managedReferences = managedReferences;
        if (relativeId != null) {
            this.addTokenToRelativeId(relativeId);
        }
        if (ignoreProperties) {
            this.propertyWrappers = null;
            return;
        }
        this.propertyWrappers = this.newArrayListWithExpectedSize(this.getJavaType().getDeclaredFields().length);
        this.processProperties();
    }

    public String getRelativeId() {
        return this.relativeId;
    }

    protected void addTokenToRelativeId(String token) {
        this.relativeId = token.startsWith("#") ? token : this.relativeId + "/" + token;
    }

    public void addProperty(PropertyWrapper propertyWrapper) {
        this.propertyWrappers.add(propertyWrapper);
        if (!this.getNode().has(TAG_PROPERTIES)) {
            this.getNode().putObject(TAG_PROPERTIES);
        }
        ((ObjectNode)this.getNode().get(TAG_PROPERTIES)).put(propertyWrapper.getName(), propertyWrapper.asJson());
        if (propertyWrapper.isRequired()) {
            this.addRequired(propertyWrapper.getName());
        }
    }

    public boolean isRequired() {
        return this.required;
    }

    public void addRequired(String name) {
        if (!this.getNode().has(TAG_REQUIRED)) {
            this.getNode().putArray(TAG_REQUIRED);
        }
        ArrayNode requiredNode = (ArrayNode)this.getNode().get(TAG_REQUIRED);
        requiredNode.add(name);
    }

    public boolean pullReference(ManagedReference managedReference) {
        if (this.managedReferences.contains(managedReference)) {
            return false;
        }
        this.managedReferences.add(managedReference);
        return true;
    }

    public boolean pushReference(ManagedReference managedReference) {
        return this.managedReferences.remove(managedReference);
    }

    @Override
    public boolean isCustomWrapper() {
        return true;
    }

    @Override
    public Iterator<PropertyWrapper> iterator() {
        return this.propertyWrappers != null ? this.propertyWrappers.iterator() : Collections.emptyIterator();
    }

    protected void processProperties() {
        HashMap<Method, Field> properties = this.findProperties();
        for (Map.Entry<Method, Field> prop : properties.entrySet()) {
            PropertyWrapper propertyWrapper = new PropertyWrapper(this, this.managedReferences, prop.getKey(), prop.getValue());
            if (propertyWrapper.isEmptyWrapper()) continue;
            this.addProperty(propertyWrapper);
        }
    }

    private HashMap<Method, Field> findProperties() {
        Field[] fields = new Field[]{};
        Class<?> javaType = this.getJavaType();
        while (javaType.getSuperclass() != null) {
            fields = this.concatFieldArrays(fields, javaType.getDeclaredFields());
            javaType = javaType.getSuperclass();
        }
        Method[] methods = this.getJavaType().getMethods();
        Arrays.sort(methods, new Comparator<Method>(){

            @Override
            public int compare(Method m1, Method m2) {
                return m1.getName().compareTo(m2.getName());
            }
        });
        LinkedHashMap<Method, Field> props = new LinkedHashMap<Method, Field>();
        for (Method method : methods) {
            Class<?> declaringClass = method.getDeclaringClass();
            if (declaringClass.equals(Object.class) || Collection.class.isAssignableFrom(declaringClass) || !this.isGetter(method)) continue;
            boolean hasField = false;
            for (Field field : fields) {
                String name = this.getNameFromGetter(method);
                if (!field.getName().equalsIgnoreCase(name)) continue;
                props.put(method, field);
                hasField = true;
                break;
            }
            if (hasField) continue;
            props.put(method, null);
        }
        return props;
    }

    private boolean isGetter(Method method) {
        return method.getName().startsWith("get") || method.getName().startsWith("is");
    }

    private String getNameFromGetter(Method getter) {
        String[] getterPrefixes = new String[]{"get", "is"};
        String methodName = getter.getName();
        String fieldName = null;
        for (String prefix : getterPrefixes) {
            if (!methodName.startsWith(prefix)) continue;
            fieldName = methodName.substring(prefix.length());
        }
        if (fieldName == null || "".equals(fieldName)) {
            return null;
        }
        fieldName = fieldName.substring(0, 1).toLowerCase() + fieldName.substring(1);
        return fieldName;
    }

    private Field[] concatFieldArrays(Field[] first, Field[] second) {
        Field[] result = new Field[first.length + second.length];
        System.arraycopy(first, 0, result, 0, first.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    private <E> ArrayList<E> newArrayListWithExpectedSize(int estimatedSize) {
        return new ArrayList(5 + estimatedSize + estimatedSize / 10);
    }

    protected void setRequired(boolean required) {
        this.required = required;
    }

    protected void processAttributes(ObjectNode node, Type type) {
        Attributes attributes = this.getJavaType().getAnnotation(Attributes.class);
        if (attributes != null) {
            JJSchemaUtil.processCommonAttributes(node, attributes);
            if (attributes.required()) {
                this.setRequired(true);
            }
            if (!attributes.additionalProperties()) {
                node.put("additionalProperties", false);
            }
        }
    }
}

