/*
 * Decompiled with CFR 0.152.
 */
package com.github.reinert.jjschema.v1;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.reinert.jjschema.Nullable;
import com.github.reinert.jjschema.v1.SchemaWrapperFactory;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public abstract class SchemaWrapper {
    private final Type type;
    private final ObjectNode node = SchemaWrapperFactory.MAPPER.createObjectNode();
    public static final String DRAFT_04 = "http://json-schema.org/draft-04/schema#";

    public SchemaWrapper(Type type) {
        this.type = type;
    }

    public JsonNode asJson() {
        return this.node;
    }

    public String getDollarSchema() {
        return this.getNodeTextValue(this.node.get("$schema"));
    }

    public SchemaWrapper putDollarSchema() {
        this.node.put("$schema", DRAFT_04);
        return this;
    }

    public String getId() {
        return this.getNodeTextValue(this.node.get("id"));
    }

    public String getRef() {
        return this.getNodeTextValue(this.node.get("$ref"));
    }

    public String getType() {
        return this.getNodeTextValue(this.node.get("type"));
    }

    public ParameterizedType getParameterizedType() {
        return (ParameterizedType)(this.type instanceof ParameterizedType ? this.type : null);
    }

    public Class<?> getJavaType() {
        return (Class)(this.type instanceof ParameterizedType ? ((ParameterizedType)this.type).getRawType() : this.type);
    }

    public boolean isEnumWrapper() {
        return false;
    }

    public boolean isSimpleWrapper() {
        return false;
    }

    public boolean isCustomWrapper() {
        return false;
    }

    public boolean isRefWrapper() {
        return false;
    }

    public boolean isArrayWrapper() {
        return false;
    }

    public boolean isEmptyWrapper() {
        return false;
    }

    public boolean isNullWrapper() {
        return false;
    }

    public <T extends SchemaWrapper> T cast() {
        return (T)this;
    }

    protected ObjectNode getNode() {
        return this.node;
    }

    protected void processNullable() {
        Nullable nullable = this.getJavaType().getAnnotation(Nullable.class);
        if (nullable != null) {
            String oldType = this.node.get("type").asText();
            ArrayNode typeArray = this.node.putArray("type");
            typeArray.add(oldType);
            typeArray.add("null");
        }
    }

    protected String getNodeTextValue(JsonNode node) {
        return node == null ? null : node.textValue();
    }

    protected void setType(String type) {
        this.node.put("type", type);
    }
}

