/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.restrictions.common;

import com.github.rvesse.airline.model.ArgumentsMetadata;
import com.github.rvesse.airline.model.OptionMetadata;
import com.github.rvesse.airline.parser.ParseState;
import com.github.rvesse.airline.parser.errors.ParseArgumentsIllegalValueException;
import com.github.rvesse.airline.parser.errors.ParseOptionIllegalValueException;
import com.github.rvesse.airline.restrictions.AbstractCommonRestriction;
import com.github.rvesse.airline.restrictions.common.AbstractAllowedValuesRestriction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class AllowedEnumValuesRestriction
extends AbstractAllowedValuesRestriction {
    public AllowedEnumValuesRestriction(Class<? extends Enum<?>> cls) {
        super(false);
        this.rawValues.addAll(this.getValues(cls));
    }

    private Collection<String> getValues(Class<? extends Enum<?>> cls) {
        if (cls.isEnum()) {
            ArrayList<String> values = new ArrayList<String>();
            for (Enum<?> member : cls.getEnumConstants()) {
                values.add(member.name());
            }
            return values;
        }
        return Collections.emptySet();
    }

    @Override
    public <T> void preValidate(ParseState<T> state, OptionMetadata option, String value) {
        if (this.rawValues.isEmpty()) {
            return;
        }
        if (!this.rawValues.contains(value)) {
            throw new ParseOptionIllegalValueException(option.getTitle(), (Object)value, AllowedEnumValuesRestriction.asObjects(this.rawValues));
        }
    }

    @Override
    public <T> void preValidate(ParseState<T> state, ArgumentsMetadata arguments, String value) {
        if (this.rawValues.isEmpty()) {
            return;
        }
        if (!this.rawValues.contains(value)) {
            throw new ParseArgumentsIllegalValueException(AbstractCommonRestriction.getArgumentTitle(state, arguments), (Object)value, AllowedEnumValuesRestriction.asObjects(this.rawValues));
        }
    }
}

