/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram;

import htsjdk.samtools.cram.CRAIEntry;
import htsjdk.samtools.cram.CRAMException;
import htsjdk.samtools.cram.ref.ReferenceContext;
import htsjdk.samtools.cram.structure.AlignmentSpan;

public class BAIEntry
implements Comparable<BAIEntry> {
    final ReferenceContext referenceContext;
    final AlignmentSpan alignmentSpan;
    final long containerStartByteOffset;
    final long sliceByteOffsetFromCompressionHeaderStart;
    final int landmarkIndex;

    public BAIEntry(ReferenceContext referenceContext, AlignmentSpan alignmentSpan, long containerStartByteOffset, long sliceHeaderBlockByteOffset, int landmarkIndex) {
        if (referenceContext.equals(ReferenceContext.MULTIPLE_REFERENCE_CONTEXT)) {
            throw new CRAMException("Attempt to create BAI entry from a multi ref context");
        }
        if (referenceContext.equals(ReferenceContext.UNMAPPED_UNPLACED_CONTEXT) && (alignmentSpan.getAlignmentStart() != 0 && alignmentSpan.getAlignmentStart() != -1 || alignmentSpan.getAlignmentSpan() != 0 && alignmentSpan.getAlignmentSpan() != 1)) {
            throw new CRAMException(String.format("Attempt to create a bai entry for an unmapped slice with unexpected alignment start (%d) or span (%d) values", alignmentSpan.getAlignmentStart(), alignmentSpan.getAlignmentSpan()));
        }
        this.referenceContext = referenceContext;
        this.alignmentSpan = alignmentSpan;
        this.containerStartByteOffset = containerStartByteOffset;
        this.sliceByteOffsetFromCompressionHeaderStart = sliceHeaderBlockByteOffset;
        this.landmarkIndex = landmarkIndex;
    }

    public BAIEntry(CRAIEntry craiEntry) {
        this(new ReferenceContext(craiEntry.getSequenceId()), new AlignmentSpan(craiEntry.getAlignmentStart(), craiEntry.getAlignmentSpan(), 0, 0, 0), craiEntry.getContainerStartByteOffset(), craiEntry.getSliceByteOffsetFromCompressionHeaderStart(), 0);
    }

    @Override
    public int compareTo(BAIEntry other) {
        if (this.getReferenceContext().getReferenceContextID() != other.getReferenceContext().getReferenceContextID()) {
            if (this.getReferenceContext().getReferenceContextID() == -1) {
                return 1;
            }
            if (other.getReferenceContext().getReferenceContextID() == -1) {
                return -1;
            }
            return Integer.compare(this.getReferenceContext().getReferenceSequenceID(), other.getReferenceContext().getReferenceSequenceID());
        }
        if (this.getReferenceContext().getReferenceContextID() != -1 && this.getAlignmentStart() != other.getAlignmentStart()) {
            return Integer.compare(this.getAlignmentStart(), other.getAlignmentStart());
        }
        if (this.getContainerStartByteOffset() != other.getContainerStartByteOffset()) {
            return Long.compare(this.getContainerStartByteOffset(), other.getContainerStartByteOffset());
        }
        return Long.compare(this.getSliceByteOffsetFromCompressionHeaderStart(), other.getSliceByteOffsetFromCompressionHeaderStart());
    }

    public ReferenceContext getReferenceContext() {
        return this.referenceContext;
    }

    public int getAlignmentStart() {
        return this.alignmentSpan.getAlignmentStart();
    }

    public int getAlignmentSpan() {
        return this.alignmentSpan.getAlignmentSpan();
    }

    public int getMappedReadsCount() {
        return this.alignmentSpan.getMappedCount();
    }

    public int getUnmappedReadsCount() {
        return this.alignmentSpan.getUnmappedCount();
    }

    public int getUnmappedUnplacedReadsCount() {
        return this.alignmentSpan.getUnmappedUnplacedCount();
    }

    public long getContainerStartByteOffset() {
        return this.containerStartByteOffset;
    }

    public long getSliceByteOffsetFromCompressionHeaderStart() {
        return this.sliceByteOffsetFromCompressionHeaderStart;
    }

    public int getLandmarkIndex() {
        return this.landmarkIndex;
    }
}

