/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.build;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.cram.common.CRAMVersion;
import htsjdk.samtools.cram.common.CramVersions;
import htsjdk.samtools.cram.structure.CramHeader;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class CramIO {
    @Deprecated
    public static final String CRAM_FILE_EXTENSION = ".cram";
    public static final byte[] ZERO_B_EOF_MARKER = new byte[]{11, 0, 0, 0, -1, -1, -1, -1, -1, -32, 69, 79, 70, 0, 0, 0, 0, 1, 0, 0, 1, 0, 6, 6, 1, 0, 1, 0, 1, 0};
    public static final byte[] ZERO_F_EOF_MARKER = new byte[]{15, 0, 0, 0, -1, -1, -1, -1, 15, -32, 69, 79, 70, 0, 0, 0, 0, 1, 0, 5, -67, -39, 79, 0, 1, 0, 6, 6, 1, 0, 1, 0, 1, 0, -18, 99, 1, 75};
    public static final int EOF_ALIGNMENT_START = 4542278;
    public static final int EOF_BLOCK_SIZE_V3 = 15;
    public static final int EOF_BLOCK_SIZE_V2 = 11;
    public static final int EOF_ALIGNMENT_SPAN = 0;

    public static long writeCramEOF(CRAMVersion cramVersion, OutputStream outputStream) {
        try {
            if (cramVersion.compatibleWith(CramVersions.CRAM_v3)) {
                outputStream.write(ZERO_F_EOF_MARKER);
                return ZERO_F_EOF_MARKER.length;
            }
            if (cramVersion.compatibleWith(CramVersions.CRAM_v2_1)) {
                outputStream.write(ZERO_B_EOF_MARKER);
                return ZERO_B_EOF_MARKER.length;
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        throw new IllegalArgumentException(String.format("Unrecognized CRAM version %s", cramVersion));
    }

    public static long writeCramHeader(CramHeader cramHeader, OutputStream outputStream) {
        try {
            outputStream.write(CramHeader.MAGIC);
            outputStream.write(cramHeader.getCRAMVersion().getMajor());
            outputStream.write(cramHeader.getCRAMVersion().getMinor());
            outputStream.write(cramHeader.getId());
            for (int i = cramHeader.getId().length; i < 20; ++i) {
                outputStream.write(0);
            }
            return CramHeader.CRAM_HEADER_LENGTH;
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    public static CramHeader readCramHeader(InputStream inputStream) {
        try {
            for (byte magicByte : CramHeader.MAGIC) {
                if (magicByte == inputStream.read()) continue;
                throw new RuntimeException("Input does not have a valid CRAM header.");
            }
            CRAMVersion cramVersion = new CRAMVersion(inputStream.read(), inputStream.read());
            if (!CramVersions.isSupportedVersion(cramVersion)) {
                throw new RuntimeException(String.format("CRAM version %s is not supported", cramVersion));
            }
            CramHeader header = new CramHeader(cramVersion, null);
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            dataInputStream.readFully(header.getId());
            return header;
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    /*
     * Exception decompiling
     */
    public static byte[] samHeaderToByteArray(SAMFileHeader samFileHeader) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

