/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.fastq;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMUtils;
import htsjdk.samtools.fastq.FastqEncoder;
import htsjdk.samtools.util.StringUtil;
import java.io.Serializable;

public class FastqRecord
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String readName;
    private final String readString;
    private final String qualityHeader;
    private final String baseQualityString;

    public FastqRecord(String readName, String readBases, String qualityHeader, String baseQualities) {
        this.readName = readName != null && !readName.isEmpty() ? readName : null;
        this.qualityHeader = qualityHeader != null && !qualityHeader.isEmpty() ? qualityHeader : null;
        this.readString = readBases;
        this.baseQualityString = baseQualities;
    }

    public FastqRecord(String readName, byte[] readBases, String qualityHeader, byte[] baseQualities) {
        this(readName, StringUtil.bytesToString(readBases), qualityHeader, SAMUtils.phredToFastq(baseQualities));
    }

    public FastqRecord(FastqRecord other) {
        if (other == null) {
            throw new IllegalArgumentException("new FastqRecord(null)");
        }
        this.readName = other.readName;
        this.readString = other.readString;
        this.qualityHeader = other.qualityHeader;
        this.baseQualityString = other.baseQualityString;
    }

    @Deprecated
    public String getReadHeader() {
        return this.getReadName();
    }

    public String getReadName() {
        return this.readName;
    }

    public String getReadString() {
        return this.readString;
    }

    public byte[] getReadBases() {
        return this.readString == null ? SAMRecord.NULL_SEQUENCE : StringUtil.stringToBytes(this.readString);
    }

    public String getBaseQualityString() {
        return this.baseQualityString;
    }

    public byte[] getBaseQualities() {
        return this.baseQualityString == null ? SAMRecord.NULL_QUALS : SAMUtils.fastqToPhred(this.baseQualityString);
    }

    public int getReadLength() {
        return this.readString == null ? 0 : this.readString.length();
    }

    public String getBaseQualityHeader() {
        return this.qualityHeader;
    }

    @Deprecated
    public int length() {
        return this.getReadLength();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.qualityHeader == null ? 0 : this.qualityHeader.hashCode());
        result = 31 * result + (this.baseQualityString == null ? 0 : this.baseQualityString.hashCode());
        result = 31 * result + (this.readName == null ? 0 : this.readName.hashCode());
        result = 31 * result + (this.readString == null ? 0 : this.readString.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FastqRecord other = (FastqRecord)obj;
        if (this.readString == null ? other.readString != null : !this.readString.equals(other.readString)) {
            return false;
        }
        if (this.qualityHeader == null ? other.qualityHeader != null : !this.qualityHeader.equals(other.qualityHeader)) {
            return false;
        }
        if (this.baseQualityString == null ? other.baseQualityString != null : !this.baseQualityString.equals(other.baseQualityString)) {
            return false;
        }
        return !(this.readName == null ? other.readName != null : !this.readName.equals(other.readName));
    }

    public String toFastQString() {
        return FastqEncoder.encode(this);
    }

    public String toString() {
        return this.toFastQString();
    }
}

