/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.Defaults;
import htsjdk.samtools.util.LineReader;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class BufferedLineReader
extends LineNumberReader
implements LineReader {
    private static final float MAX_BYTES_PER_CHAR_UTF8 = StandardCharsets.UTF_8.newEncoder().maxBytesPerChar();

    public BufferedLineReader(InputStream is) {
        this(is, Defaults.NON_ZERO_BUFFER_SIZE);
    }

    public BufferedLineReader(InputStream is, int bufferSize) {
        super(new InputStreamReader(is, Charset.forName("UTF-8")), bufferSize);
    }

    public static BufferedLineReader fromString(String s) {
        InputStream is = (float)s.length() * MAX_BYTES_PER_CHAR_UTF8 >= 2.1474836E9f ? new StringBackedInputStream(s) : new ByteArrayInputStream(s.getBytes());
        return new BufferedLineReader(is);
    }

    @Override
    public String readLine() {
        try {
            return super.readLine();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public int peek() {
        try {
            this.mark(2);
            int ret = this.read();
            this.reset();
            return ret;
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public void close() {
        try {
            super.close();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    private static class StringBackedInputStream
    extends InputStream {
        private int idx = 0;
        private final String str;
        private final int len;

        StringBackedInputStream(String str) {
            this.str = str;
            this.len = str.length();
        }

        @Override
        public int read() throws IOException {
            if (this.idx >= this.len) {
                return -1;
            }
            return this.str.charAt(this.idx++);
        }
    }
}

