/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.tribble.index.tabix;

import htsjdk.samtools.BinningIndexBuilder;
import htsjdk.samtools.BinningIndexContent;
import htsjdk.samtools.Chunk;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.tribble.Feature;
import htsjdk.tribble.index.Index;
import htsjdk.tribble.index.IndexCreator;
import htsjdk.tribble.index.tabix.TabixFormat;
import htsjdk.tribble.index.tabix.TabixIndex;
import htsjdk.utils.ValidationUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class AllRefsTabixIndexCreator
implements IndexCreator {
    private final TabixFormat formatSpec;
    private final List<BinningIndexContent> indexContents = new ArrayList<BinningIndexContent>();
    private final SAMSequenceDictionary sequenceDictionary;
    private int currentReferenceIndex = -1;
    private BinningIndexBuilder indexBuilder = null;
    private TabixFeature previousFeature = null;

    public AllRefsTabixIndexCreator(SAMSequenceDictionary sequenceDictionary, TabixFormat formatSpec) {
        ValidationUtils.nonNull(sequenceDictionary);
        this.sequenceDictionary = sequenceDictionary;
        this.formatSpec = formatSpec.clone();
    }

    @Override
    public void addFeature(Feature feature, long filePosition) {
        String sequenceName = feature.getContig();
        int referenceIndex = this.sequenceDictionary.getSequenceIndex(sequenceName);
        boolean advance = false;
        if (this.currentReferenceIndex == -1) {
            for (int i = 0; i < referenceIndex; ++i) {
                this.indexContents.add(null);
            }
            this.currentReferenceIndex = referenceIndex;
            advance = true;
        } else {
            if (referenceIndex == this.currentReferenceIndex + 1) {
                advance = true;
            }
            if (referenceIndex != this.currentReferenceIndex && referenceIndex != this.currentReferenceIndex + 1) {
                throw new IllegalArgumentException("Sequence " + feature + " added out of order" + " currentReferenceIndex: " + this.currentReferenceIndex + ", referenceIndex:" + referenceIndex);
            }
        }
        TabixFeature thisFeature = new TabixFeature(referenceIndex, feature.getStart(), feature.getEnd(), filePosition);
        if (this.previousFeature != null) {
            if (this.previousFeature.compareTo(thisFeature) > 0) {
                throw new IllegalArgumentException(String.format("Features added out of order: previous (%s) > next (%s)", this.previousFeature, thisFeature));
            }
            this.finalizeFeature(filePosition);
        }
        this.previousFeature = thisFeature;
        if (advance) {
            this.advanceToReference(referenceIndex);
        }
    }

    private void finalizeFeature(long featureEndPosition) {
        this.previousFeature.featureEndFilePosition = featureEndPosition;
        if (this.previousFeature.featureStartFilePosition >= this.previousFeature.featureEndFilePosition) {
            throw new IllegalArgumentException(String.format("Feature start position %d >= feature end position %d", this.previousFeature.featureStartFilePosition, this.previousFeature.featureEndFilePosition));
        }
        this.indexBuilder.processFeature(this.previousFeature);
    }

    private void advanceToReference(int referenceIndex) {
        if (this.indexBuilder != null) {
            this.indexContents.add(this.indexBuilder.generateIndexContent());
        }
        int sequenceLength = this.sequenceDictionary != null ? this.sequenceDictionary.getSequence(referenceIndex).getSequenceLength() : 0;
        this.indexBuilder = new BinningIndexBuilder(referenceIndex, sequenceLength);
        this.currentReferenceIndex = referenceIndex;
    }

    @Override
    public Index finalizeIndex(long finalFilePosition) {
        if (this.previousFeature != null) {
            this.finalizeFeature(finalFilePosition);
        }
        if (this.indexBuilder != null) {
            this.indexContents.add(this.indexBuilder.generateIndexContent());
        }
        BinningIndexContent[] indices = this.indexContents.toArray(new BinningIndexContent[this.sequenceDictionary.size()]);
        List<String> sequenceNames = this.sequenceDictionary.getSequences().stream().map(SAMSequenceRecord::getSequenceName).collect(Collectors.toList());
        return new TabixIndex(this.formatSpec, sequenceNames, indices);
    }

    private static class TabixFeature
    implements BinningIndexBuilder.FeatureToBeIndexed,
    Comparable<TabixFeature> {
        private final int referenceIndex;
        private final int start;
        private final int end;
        private final long featureStartFilePosition;
        private long featureEndFilePosition = -1L;

        private TabixFeature(int referenceIndex, int start, int end, long featureStartFilePosition) {
            this.referenceIndex = referenceIndex;
            this.start = start;
            this.end = end;
            this.featureStartFilePosition = featureStartFilePosition;
        }

        @Override
        public int getStart() {
            return this.start;
        }

        @Override
        public int getEnd() {
            return this.end;
        }

        @Override
        public Integer getIndexingBin() {
            return null;
        }

        @Override
        public Chunk getChunk() {
            if (this.featureEndFilePosition == -1L) {
                throw new IllegalStateException("End position is not set");
            }
            return new Chunk(this.featureStartFilePosition, this.featureEndFilePosition);
        }

        @Override
        public int compareTo(TabixFeature other) {
            int ret = this.referenceIndex - other.referenceIndex;
            if (ret != 0) {
                return ret;
            }
            return this.start - other.start;
        }

        public String toString() {
            return "TabixFeature{referenceIndex=" + this.referenceIndex + ", start=" + this.start + ", end=" + this.end + ", featureStartFilePosition=" + this.featureStartFilePosition + ", featureEndFilePosition=" + this.featureEndFilePosition + '}';
        }
    }
}

