/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbaudoin.sonar.plugins.yaml.checks;

import com.github.sbaudoin.sonar.plugins.yaml.checks.ForbiddenCheck;
import com.github.sbaudoin.yamllint.LintScanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.yaml.snakeyaml.tokens.ScalarToken;
import org.yaml.snakeyaml.tokens.Token;
import org.yaml.snakeyaml.tokens.ValueToken;

@Rule(key="ForbiddenValueCheck")
public class ForbiddenValueCheck
extends ForbiddenCheck {
    @RuleProperty(key="value", description="Regexp that matches the forbidden value")
    String value;

    @Override
    protected void checkNextToken(LintScanner parser) {
        Token t = parser.getToken();
        if (parser.peekToken() instanceof ValueToken) {
            Matcher m;
            parser.getToken();
            Token t3 = parser.peekToken();
            if (t3 instanceof ScalarToken && (m = Pattern.compile("(?m)" + this.value).matcher(((ScalarToken)t3).getValue())).find()) {
                this.addViolation("Forbidden value found", t);
            }
        }
    }
}

