/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbaudoin.sonar.plugins.yaml.checks;

import com.github.sbaudoin.sonar.plugins.yaml.checks.YamlIssue;
import com.github.sbaudoin.sonar.plugins.yaml.checks.YamlLintIssue;
import com.github.sbaudoin.yamllint.LintProblem;
import com.github.sbaudoin.yamllint.Linter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;

public class YamlSourceCode {
    private static final Logger LOGGER = Loggers.get(YamlSourceCode.class);
    private final List<YamlIssue> yamlIssues = new ArrayList<YamlIssue>();
    private YamlIssue syntaxError = null;
    private boolean filter;
    private InputFile yamlFile;
    private String content = null;

    public YamlSourceCode(InputFile yamlFile, Optional<Boolean> filter) throws IOException {
        this.yamlFile = yamlFile;
        this.filter = filter.orElse(false);
        LintProblem problem = Linter.getSyntaxError((CharSequence)this.getContent());
        LOGGER.debug("File {} has syntax error? {}", (Object)yamlFile.uri(), (Object)(problem != null ? 1 : 0));
        if (problem != null) {
            this.syntaxError = new YamlLintIssue(problem, null, true);
        }
    }

    public InputFile getYamlFile() {
        return this.yamlFile;
    }

    public String getContent() throws IOException {
        if (this.content == null) {
            this.content = this.filter ? this.yamlFile.contents().replace("\u0085", "").replace("\u2028", "").replace("\u2029", "") : this.yamlFile.contents();
        }
        return this.content;
    }

    public void addViolation(YamlIssue issue) {
        this.yamlIssues.add(issue);
        if (issue.isSyntaxError() && this.syntaxError == null) {
            this.syntaxError = issue;
        }
    }

    public YamlIssue getSyntaxError() {
        return this.syntaxError;
    }

    public boolean hasCorrectSyntax() {
        return this.syntaxError == null;
    }

    public List<YamlIssue> getYamlIssues() {
        return this.yamlIssues;
    }
}

