/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbaudoin.sonar.plugins.yaml.highlighting;

import org.yaml.snakeyaml.error.Mark;

public class YamlLocation {
    private final String content;
    private final int line;
    private final int column;
    private final int characterOffset;

    YamlLocation(String content) {
        this(content, 1, 1, 0);
    }

    YamlLocation(String content, Mark mark) {
        this(content, mark.getLine() + 1, mark.getColumn() + 1, mark.getPointer());
    }

    public YamlLocation(String content, int line, int column, int characterOffset) {
        this.content = content;
        this.line = line;
        this.column = column;
        this.characterOffset = characterOffset;
    }

    public int line() {
        return this.line;
    }

    public int column() {
        return this.column;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{ ");
        sb.append("content: \"").append(this.content).append("\"; ");
        sb.append("line: ").append(this.line).append("; ");
        sb.append("column: ").append(this.column).append("; ");
        sb.append("characterOffset: ").append(this.characterOffset);
        sb.append(" }");
        return sb.toString();
    }

    public YamlLocation shift(int nbChar) {
        if (this.characterOffset + nbChar > this.content.length()) {
            throw new IllegalStateException("Cannot shift by " + nbChar + " characters");
        }
        YamlLocation res = this;
        for (int i = 0; i < nbChar; ++i) {
            res = res.shift(res.readChar());
        }
        return res;
    }

    public char readChar() {
        return this.content.charAt(this.characterOffset);
    }

    private YamlLocation shift(char c) {
        if (c == '\n') {
            return new YamlLocation(this.content, this.line + 1, 1, this.characterOffset + 1);
        }
        return new YamlLocation(this.content, this.line, this.column + 1, this.characterOffset + 1);
    }

    public YamlLocation moveBefore(String substring) {
        int index = this.content.indexOf(substring, this.characterOffset);
        if (index == -1) {
            throw new IllegalStateException("Cannot find " + substring + " in " + this.content.substring(this.characterOffset));
        }
        return this.shift(index);
    }

    public boolean isSameAs(YamlLocation other) {
        return this.characterOffset == other.characterOffset;
    }
}

