/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbaudoin.sonar.plugins.yaml.linecounter;

import com.github.sbaudoin.sonar.plugins.yaml.linecounter.LineCountData;
import com.github.sbaudoin.yamllint.Parser;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public final class LineCountParser {
    private int linesNumber = 0;
    private Set<Integer> commentLines = new HashSet<Integer>();
    private Set<Integer> linesOfCodeLines = new HashSet<Integer>();
    private LineCountData data;

    public LineCountParser(String contents) {
        List lines = Parser.getLines((String)contents);
        for (Parser.Line line : lines) {
            String lineContent = line.getContent();
            if (this.isCommentLine(lineContent)) {
                this.commentLines.add(line.getLineNo());
            } else if (!StringUtils.isBlank((String)lineContent)) {
                this.linesOfCodeLines.add(line.getLineNo());
            }
            if (line.getLineNo() <= this.linesNumber) continue;
            this.linesNumber = line.getLineNo();
        }
        this.data = new LineCountData(this.linesNumber, this.linesOfCodeLines, this.commentLines);
    }

    public LineCountData getLineCountData() {
        return this.data;
    }

    private boolean isCommentLine(String lineContent) {
        assert (lineContent != null);
        return lineContent.trim().matches("^\\h*#\\h*\\S.*");
    }
}

