/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbaudoin.sonar.plugins.yaml.rules;

import com.github.sbaudoin.sonar.plugins.yaml.checks.CheckRepository;
import com.github.sbaudoin.sonar.plugins.yaml.checks.YamlCheck;
import com.github.sbaudoin.sonar.plugins.yaml.checks.YamlIssue;
import com.github.sbaudoin.sonar.plugins.yaml.checks.YamlSourceCode;
import com.github.sbaudoin.sonar.plugins.yaml.highlighting.HighlightingData;
import com.github.sbaudoin.sonar.plugins.yaml.highlighting.YamlHighlighting;
import com.github.sbaudoin.sonar.plugins.yaml.linecounter.LineCounter;
import com.github.sbaudoin.yamllint.YamlLintConfig;
import com.github.sbaudoin.yamllint.YamlLintConfigException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextPointer;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.batch.rule.Checks;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.batch.sensor.highlighting.NewHighlighting;
import org.sonar.api.batch.sensor.issue.NewIssue;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;

public class YamlSensor
implements Sensor {
    private static final Logger LOGGER = Loggers.get(YamlSensor.class);
    private final Checks<Object> checks;
    private final FileSystem fileSystem;
    private final FilePredicate mainFilesPredicate;
    private final FileLinesContextFactory fileLinesContextFactory;
    protected final YamlLintConfig localConfig;
    public static final String USER_CONF_FILENAME = ".yamllint";

    public YamlSensor(FileSystem fileSystem, CheckFactory checkFactory, FileLinesContextFactory fileLinesContextFactory) {
        this.fileLinesContextFactory = fileLinesContextFactory;
        this.checks = checkFactory.create("yaml").addAnnotatedChecks(CheckRepository.getCheckClasses());
        this.fileSystem = fileSystem;
        this.mainFilesPredicate = fileSystem.predicates().and(fileSystem.predicates().hasType(InputFile.Type.MAIN), fileSystem.predicates().hasLanguage("yaml"));
        this.localConfig = this.getLocalConfig();
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.onlyOnLanguage("yaml");
        descriptor.name("YAML Sensor");
    }

    public void execute(SensorContext context) {
        LOGGER.debug("YAML sensor executed with context: " + context);
        Optional<RuleKey> parsingErrorKey = this.getParsingErrorRuleKey();
        boolean skipChecks = false;
        if (context.activeRules().findByRepository("yaml").isEmpty()) {
            LOGGER.info("No active rules found for this plugin, skipping.");
            skipChecks = true;
        }
        for (InputFile inputFile : this.fileSystem.inputFiles(this.mainFilesPredicate)) {
            LOGGER.debug("Analyzing file: " + inputFile.filename());
            try {
                YamlSourceCode sourceCode = new YamlSourceCode(inputFile, context.config().getBoolean("sonar.yaml.filter.utf8_lb"));
                this.computeLinesMeasures(context, sourceCode);
                YamlSensor.saveSyntaxHighlighting(context, sourceCode);
                if (skipChecks) continue;
                if (!sourceCode.hasCorrectSyntax()) {
                    LOGGER.debug("File has syntax errors");
                    YamlSensor.processAnalysisError(context, sourceCode, inputFile, parsingErrorKey);
                }
                this.runChecks(context, sourceCode);
            }
            catch (IOException e) {
                LOGGER.warn("Error reading source file " + inputFile.filename(), (Throwable)e);
            }
        }
    }

    private void computeLinesMeasures(SensorContext context, YamlSourceCode sourceCode) {
        LineCounter.analyse(context, this.fileLinesContextFactory, sourceCode);
    }

    private Optional<RuleKey> getParsingErrorRuleKey() {
        for (Object obj : this.checks.all()) {
            YamlCheck check = (YamlCheck)obj;
            if (!check.getClass().equals(CheckRepository.getParsingErrorCheckClass())) continue;
            LOGGER.debug("Parsing error rule key found: " + check.getRuleKey());
            return Optional.of(this.checks.ruleKey((Object)check));
        }
        LOGGER.debug("No parsing error rule key found");
        return Optional.empty();
    }

    private void runChecks(SensorContext context, YamlSourceCode sourceCode) {
        for (Object check : this.checks.all()) {
            ((YamlCheck)check).setRuleKey(this.checks.ruleKey(check));
            ((YamlCheck)check).setYamlSourceCode(sourceCode);
            LOGGER.debug("Checking rule: " + ((YamlCheck)check).getRuleKey());
            this.setConfig((YamlCheck)check);
            ((YamlCheck)check).validate();
        }
        this.saveIssues(context, sourceCode);
    }

    private YamlLintConfig getLocalConfig() {
        Path userGlobalConfig = this.getUserGlobalConfigPath();
        try {
            if (this.fileExists(this.fileSystem.resolvePath(USER_CONF_FILENAME))) {
                return new YamlLintConfig(this.fileSystem.resolvePath(USER_CONF_FILENAME).toURI().toURL());
            }
            if (this.fileExists(this.fileSystem.resolvePath(".yamllint.yaml"))) {
                return new YamlLintConfig(this.fileSystem.resolvePath(".yamllint.yaml").toURI().toURL());
            }
            if (this.fileExists(this.fileSystem.resolvePath(".yamllint.yml"))) {
                return new YamlLintConfig(this.fileSystem.resolvePath(".yamllint.yml").toURI().toURL());
            }
            if (this.fileExists(userGlobalConfig.toString())) {
                return new YamlLintConfig(userGlobalConfig.toUri().toURL());
            }
        }
        catch (IOException e) {
            LOGGER.warn("Cannot read yamllint user configuration file: " + e.getMessage());
            LOGGER.warn("Enable debug mode to get the complete stacktrace.");
            LOGGER.debug("Complete error trace:", (Object)e);
        }
        catch (YamlLintConfigException e) {
            LOGGER.warn("Configuration error: " + e.getMessage());
            LOGGER.warn("Enable debug mode to get the complete stacktrace.");
            LOGGER.debug("Complete error trace:", (Object)e);
        }
        return null;
    }

    private void setConfig(YamlCheck check) {
        if (this.localConfig != null) {
            check.setConfig(this.localConfig);
        }
    }

    private Path getUserGlobalConfigPath() {
        Path userGlobalConfig = System.getenv("YAMLLINT_CONFIG_FILE") != null ? Paths.get(System.getenv("YAMLLINT_CONFIG_FILE"), new String[0]) : (System.getenv("XDG_CONFIG_HOME") != null ? Paths.get(System.getenv("XDG_CONFIG_HOME"), "yamllint", "config") : Paths.get(System.getProperty("user.home"), ".config", "yamllint", "config"));
        return userGlobalConfig;
    }

    private boolean fileExists(String path) {
        File file = new File(path);
        return file.exists() && file.isFile();
    }

    private boolean fileExists(File path) {
        return path.exists() && path.isFile();
    }

    private void saveIssues(SensorContext context, YamlSourceCode sourceCode) {
        for (YamlIssue yamlIssue : sourceCode.getYamlIssues()) {
            LOGGER.debug("Saving issue: " + yamlIssue.getMessage());
            NewIssue newIssue = context.newIssue().forRule(yamlIssue.getRuleKey());
            NewIssueLocation location = newIssue.newLocation().on((InputComponent)sourceCode.getYamlFile()).message(yamlIssue.getMessage()).at(sourceCode.getYamlFile().selectLine(yamlIssue.getLine() == 0 ? 1 : yamlIssue.getLine()));
            newIssue.at(location).save();
        }
    }

    private static void saveSyntaxHighlighting(SensorContext context, YamlSourceCode sourceCode) {
        List<HighlightingData> highlightingDataList;
        try {
            highlightingDataList = new YamlHighlighting(sourceCode).getHighlightingData();
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not analyze file " + sourceCode.getYamlFile().filename(), e);
        }
        NewHighlighting highlighting = context.newHighlighting().onFile(sourceCode.getYamlFile());
        for (HighlightingData highlightingData : highlightingDataList) {
            highlightingData.highlight(highlighting);
        }
        highlighting.save();
    }

    private static void processAnalysisError(SensorContext context, YamlSourceCode sourceCode, InputFile inputFile, Optional<RuleKey> parsingErrorKey) {
        final YamlIssue error = sourceCode.getSyntaxError();
        LOGGER.warn("Syntax error in file: {}", (Object)inputFile.filename());
        LOGGER.warn("Cause: {} at line {}, column {}", new Object[]{error.getMessage(), error.getLine(), error.getColumn()});
        LOGGER.debug("Creating analysis error");
        context.newAnalysisError().onFile(inputFile).message(sourceCode.getSyntaxError().getMessage()).at(new TextPointer(){

            public int line() {
                return error.getLine();
            }

            public int lineOffset() {
                return error.getColumn();
            }

            public int compareTo(TextPointer textPointer) {
                return textPointer.line() - this.line();
            }
        }).save();
        if (parsingErrorKey.isPresent()) {
            LOGGER.debug("parsingErrorKey present, creating issue");
            NewIssue newIssue = context.newIssue().forRule(parsingErrorKey.get());
            NewIssueLocation location = newIssue.newLocation().message("Parse error: " + error.getMessage()).on((InputComponent)inputFile).at(sourceCode.getYamlFile().selectLine(error.getLine()));
            newIssue.at(location).save();
        }
    }
}

