/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbaudoin.sonar.plugins.yaml.settings;

import java.util.ArrayList;
import java.util.List;
import org.sonar.api.PropertyType;
import org.sonar.api.config.PropertyDefinition;

public class YamlSettings {
    public static final String FILE_SUFFIXES_KEY = "sonar.yaml.file.suffixes";
    public static final String FILTER_UTF8_LB_KEY = "sonar.yaml.filter.utf8_lb";
    public static final String FILE_SUFFIXES_DEFAULT_VALUE = ".yaml,.yml";
    public static final String YAML_LINT_CONF_PATH_KEY = "sonar.yaml.yamllint.conf.path";
    public static final String YAML_LINT_CONF_PATH_DEFAULT_VALUE = "";

    private YamlSettings() {
    }

    public static List<PropertyDefinition> getProperties(boolean hasBuiltinYamlSupport) {
        ArrayList<PropertyDefinition> properties = new ArrayList<PropertyDefinition>();
        if (!hasBuiltinYamlSupport) {
            properties.add(PropertyDefinition.builder((String)FILE_SUFFIXES_KEY).name("File Suffixes").description("Comma-separated list of suffixes for files to analyze.").defaultValue(FILE_SUFFIXES_DEFAULT_VALUE).multiValues(true).category("YAML").onQualifiers("TRK", new String[0]).build());
        }
        properties.add(PropertyDefinition.builder((String)FILTER_UTF8_LB_KEY).name("Filter UTF-8 Line Breaks").description("Tells if UTF-8 line breaks (U+2028, U+2029 and U+0085) that may not be correctly supported by SonarQube are filtered out from the YAML code.").type(PropertyType.BOOLEAN).defaultValue("false").category("YAML").onQualifiers("TRK", new String[0]).build());
        properties.add(PropertyDefinition.builder((String)YAML_LINT_CONF_PATH_KEY).name("Path to a yamllint configuration file").description("Path (absolute or relative to project root) to a yamllint configuration file. Leave it empty to use the default .yamllint file.").defaultValue(YAML_LINT_CONF_PATH_DEFAULT_VALUE).category("YAML").onQualifiers("TRK", new String[0]).build());
        return properties;
    }
}

