/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbt.junit.jupiter.internal.filter;

import com.github.sbt.junit.jupiter.internal.event.Dispatcher;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.junit.platform.engine.FilterResult;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.launcher.PostDiscoveryFilter;

public class TestFilter
implements PostDiscoveryFilter {
    private final Set<String> testPatterns;
    private final String patternDescription;
    private final Dispatcher eventDispatcher;
    private final Map<UniqueId, FilterResult> alreadyTestedIds = new ConcurrentHashMap<UniqueId, FilterResult>();

    TestFilter(Set<String> set, Dispatcher dispatcher) {
        this.eventDispatcher = dispatcher;
        this.testPatterns = set;
        this.patternDescription = set.stream().collect(Collectors.joining(" OR "));
    }

    public static Optional<TestFilter> create(Set<String> set, Dispatcher dispatcher) {
        if (set.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new TestFilter(set, dispatcher));
    }

    public FilterResult apply(TestDescriptor testDescriptor) {
        UniqueId uniqueId2 = testDescriptor.getUniqueId();
        return this.alreadyTestedIds.computeIfAbsent(uniqueId2, uniqueId -> {
            Optional<String> optional = this.toTestName(testDescriptor);
            FilterResult filterResult = optional.map(this::findMatchingResult).orElse(FilterResult.included((String)"Not a leaf descriptor"));
            if (filterResult.excluded()) {
                String string = filterResult.getReason().orElse("");
                this.eventDispatcher.executionFiltered(testDescriptor, string);
            }
            return filterResult;
        });
    }

    private Optional<String> toTestName(TestDescriptor testDescriptor) {
        TestSource testSource = testDescriptor.getSource().orElse(null);
        if (!testDescriptor.isTest() || !(testSource instanceof MethodSource)) {
            return Optional.empty();
        }
        MethodSource methodSource = (MethodSource)testSource;
        return Optional.of(methodSource.getClassName() + '#' + methodSource.getMethodName() + '(' + methodSource.getMethodParameterTypes() + ')');
    }

    FilterResult findMatchingResult(String string) {
        return this.findMatchingPattern(string).map(string2 -> FilterResult.included((String)("Pattern <" + string2 + "> matches <" + string + ">"))).orElseGet(() -> FilterResult.excluded((String)("Does not match pattern " + this.patternDescription)));
    }

    Optional<String> findMatchingPattern(String string) {
        return this.testPatterns.stream().filter(string2 -> Pattern.matches(string2, string)).findAny();
    }
}

