/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbt.junit.jupiter.internal.listeners;

import com.github.sbt.junit.jupiter.api.StreamPair;
import com.github.sbt.junit.jupiter.internal.Configuration;
import com.github.sbt.junit.jupiter.internal.TestLogger;
import com.github.sbt.junit.jupiter.internal.listeners.OutputCapture;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;

public class OutputCapturingTestListener
implements TestExecutionListener {
    private final Map<String, CapturedOutputStream> outputStreamMap = new ConcurrentHashMap<String, CapturedOutputStream>();
    private final Consumer<String> outputConsumer;
    private final Consumer<String> errorConsumer;
    private final StreamPair systemStreamPair;
    private final TestLogger testLogger;
    private final boolean isQuiet;

    public OutputCapturingTestListener(Configuration configuration, StreamPair streamPair) {
        this.isQuiet = configuration.getOptions().isQuiet();
        this.testLogger = configuration.getLogger();
        this.outputConsumer = this.isQuiet ? string -> this.testLogger.debug((String)string, new Object[0]) : string -> this.testLogger.info((String)string, new Object[0]);
        this.errorConsumer = string -> this.testLogger.error((String)string, new Object[0]);
        this.systemStreamPair = streamPair;
    }

    public void testPlanExecutionStarted(TestPlan testPlan) {
        OutputCapture.install(this.systemStreamPair);
    }

    public void testPlanExecutionFinished(TestPlan testPlan) {
        OutputCapture.uninstall();
    }

    public void executionStarted(TestIdentifier testIdentifier) {
        this.outputStreamMap.computeIfAbsent(testIdentifier.getUniqueId(), string -> {
            CapturedOutputStream capturedOutputStream = new CapturedOutputStream(this.outputConsumer);
            CapturedOutputStream capturedOutputStream2 = new CapturedOutputStream(this.errorConsumer);
            OutputCapture.register(new PrintStream(capturedOutputStream, true), new PrintStream(capturedOutputStream2, true));
            return capturedOutputStream;
        });
    }

    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        CapturedOutputStream capturedOutputStream = this.outputStreamMap.remove(testIdentifier.getUniqueId());
        if (null == capturedOutputStream) {
            return;
        }
        OutputCapture.deregister();
        if (this.isQuiet && testIdentifier.isTest() && !TestExecutionResult.Status.SUCCESSFUL.equals((Object)testExecutionResult.getStatus())) {
            capturedOutputStream.output.forEach(string -> this.testLogger.info((String)string, new Object[0]));
            capturedOutputStream.output.clear();
        }
    }

    static class CapturedOutputStream
    extends ByteArrayOutputStream {
        final Consumer<String> consumer;
        final List<String> output = new ArrayList<String>();

        CapturedOutputStream(Consumer<String> consumer) {
            this.consumer = consumer;
        }

        @Override
        public void flush() throws IOException {
            String[] stringArray;
            for (String string : stringArray = this.toString().split("\\r?\\n")) {
                if (string.isEmpty()) continue;
                this.consumer.accept(string);
                this.output.add(string);
            }
            this.reset();
        }
    }
}

