/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbt.junit.jupiter.internal.options;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class Options {
    private static final String DISPATCH_EVENTS_TRACE_PATH = "target/jupiterDispatchEvents.log";
    private final boolean assertLogEnabled;
    private final boolean colorsEnabled;
    private final boolean decodeScalaNames;
    private final boolean exceptionClassLogEnabled;
    private final boolean quiet;
    private final boolean verbose;
    private final boolean traceDispatchEvents;
    private final boolean typesEnabled;
    private final Set<String> testFilters;
    private final List<String> includeTags;
    private final List<String> excludeTags;
    private final Set<String> globPatterns;
    private final Map<String, String> systemProperties;
    private final String displayMode;
    private final String runListener;

    private Options(Builder builder) {
        this.assertLogEnabled = builder.assertLogEnabled;
        this.colorsEnabled = builder.colorsEnabled;
        this.decodeScalaNames = builder.decodeScalaNames;
        this.exceptionClassLogEnabled = builder.exceptionClassLogEnabled;
        this.excludeTags = builder.excludeTags;
        this.globPatterns = builder.globPatterns;
        this.includeTags = builder.includeTags;
        this.quiet = builder.quiet;
        this.runListener = builder.runListener;
        this.systemProperties = builder.systemProperties;
        this.testFilters = builder.testFilters;
        this.verbose = builder.verbose;
        this.traceDispatchEvents = builder.traceDispatchEvents;
        this.typesEnabled = builder.typesEnabled;
        this.displayMode = builder.displayMode;
    }

    public boolean isColorsEnabled() {
        return this.colorsEnabled;
    }

    public boolean isDecodeScalaNames() {
        return this.decodeScalaNames;
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public boolean isAssertLogEnabled() {
        return this.assertLogEnabled;
    }

    public boolean isExceptionClassLogEnabled() {
        return this.exceptionClassLogEnabled;
    }

    public boolean isTypesEnabled() {
        return this.typesEnabled;
    }

    public String getDisplayMode() {
        return this.displayMode;
    }

    public Optional<String> getRunListener() {
        return Optional.ofNullable(this.runListener);
    }

    public Set<String> getTestFilters() {
        return this.testFilters;
    }

    public Optional<String> getDispatchEventsTracePath() {
        return Optional.ofNullable(this.traceDispatchEvents ? DISPATCH_EVENTS_TRACE_PATH : null);
    }

    public List<String> getIncludeTags() {
        return this.includeTags;
    }

    public List<String> getExcludeTags() {
        return this.excludeTags;
    }

    public Set<String> getGlobPatterns() {
        return this.globPatterns;
    }

    public Map<String, String> getSystemProperties() {
        return this.systemProperties;
    }

    static class Builder {
        private boolean quiet = false;
        private boolean verbose = true;
        private boolean colorsEnabled = true;
        private boolean decodeScalaNames = false;
        private boolean assertLogEnabled = true;
        private boolean exceptionClassLogEnabled = true;
        private boolean traceDispatchEvents = false;
        private boolean typesEnabled = false;
        private Set<String> testFilters = new HashSet<String>();
        private List<String> includeTags = new ArrayList<String>();
        private List<String> excludeTags = new ArrayList<String>();
        private Set<String> globPatterns = new HashSet<String>();
        private Map<String, String> systemProperties = new HashMap<String, String>();
        private String displayMode = "flat";
        private String runListener;

        Builder() {
        }

        Builder withQuiet(boolean bl) {
            this.quiet = bl;
            return this;
        }

        Builder withVerbose(boolean bl) {
            this.verbose = bl;
            return this;
        }

        Builder withColorsEnabled(boolean bl) {
            this.colorsEnabled = bl;
            return this;
        }

        Builder withDecodeScalaNames(boolean bl) {
            this.decodeScalaNames = bl;
            return this;
        }

        Builder withAssertLogEnabled(boolean bl) {
            this.assertLogEnabled = bl;
            return this;
        }

        Builder withExceptionClassLogEnabled(boolean bl) {
            this.exceptionClassLogEnabled = bl;
            return this;
        }

        Builder withDisplayMode(String string) {
            this.displayMode = string;
            return this;
        }

        Builder withTraceDispatchEvents(boolean bl) {
            this.traceDispatchEvents = bl;
            return this;
        }

        Builder withTestFilters(Set<String> set) {
            this.testFilters.addAll(set);
            return this;
        }

        Builder withTypesEnabled(boolean bl) {
            this.typesEnabled = bl;
            return this;
        }

        Builder withIncludeTags(Set<String> set) {
            this.includeTags.addAll(set);
            return this;
        }

        Builder withExcludeTags(Set<String> set) {
            this.excludeTags.addAll(set);
            return this;
        }

        Builder withRunListener(String string) {
            this.runListener = string;
            return this;
        }

        Builder withGlobPattern(String string) {
            this.globPatterns.add(string);
            return this;
        }

        Builder withSystemProperty(Map.Entry<String, String> entry) {
            this.systemProperties.put(entry.getKey(), entry.getValue());
            return this;
        }

        public Options build() {
            return new Options(this);
        }
    }
}

