/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.model;

import com.github.scribejava.core.model.Token;
import com.github.scribejava.core.utils.Preconditions;
import java.util.Objects;

public class OAuth2AccessToken
extends Token {
    private static final long serialVersionUID = 8901381135476613449L;
    private String accessToken;
    private String tokenType;
    private Integer expiresIn;
    private String refreshToken;
    private String scope;

    public OAuth2AccessToken(String accessToken) {
        this(accessToken, null);
    }

    public OAuth2AccessToken(String accessToken, String rawResponse) {
        this(accessToken, null, null, null, null, rawResponse);
    }

    public OAuth2AccessToken(String accessToken, String tokenType, Integer expiresIn, String refreshToken, String scope, String rawResponse) {
        super(rawResponse);
        Preconditions.checkNotNull(accessToken, "access_token can't be null");
        this.accessToken = accessToken;
        this.tokenType = tokenType;
        this.expiresIn = expiresIn;
        this.refreshToken = refreshToken;
        this.scope = scope;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public Integer getExpiresIn() {
        return this.expiresIn;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public String getScope() {
        return this.scope;
    }

    public int hashCode() {
        int hash = 7;
        hash = 41 * hash + Objects.hashCode(this.accessToken);
        hash = 41 * hash + Objects.hashCode(this.tokenType);
        hash = 41 * hash + Objects.hashCode(this.expiresIn);
        hash = 41 * hash + Objects.hashCode(this.refreshToken);
        hash = 41 * hash + Objects.hashCode(this.scope);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OAuth2AccessToken other = (OAuth2AccessToken)obj;
        if (!Objects.equals(this.accessToken, other.getAccessToken())) {
            return false;
        }
        if (!Objects.equals(this.tokenType, other.getTokenType())) {
            return false;
        }
        if (!Objects.equals(this.refreshToken, other.getRefreshToken())) {
            return false;
        }
        if (!Objects.equals(this.scope, other.getScope())) {
            return false;
        }
        return Objects.equals(this.expiresIn, other.getExpiresIn());
    }
}

