/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.design;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class ChildBlockLengthCheck
extends AbstractCheck {
    public static final String MSG_KEY = "child.block.length";
    private static final double PERCENTS_FACTOR = 100.0;
    private static final double DEFAULT_MAX_CHILD_BLOCK_PERCENTAGE = 80.0;
    private static final int DEFAULT_IGNORE_BLOCK_LINESCOUNT = 50;
    private int[] blockTypes;
    private double maxChildBlockPercentage = 80.0;
    private int ignoreBlockLinesCount = 50;

    public void setBlockTypes(String ... blockTypes) {
        this.blockTypes = new int[blockTypes.length];
        for (int index = 0; index < blockTypes.length; ++index) {
            this.blockTypes[index] = TokenUtil.getTokenId((String)blockTypes[index]);
        }
    }

    public void setMaxChildBlockPercentage(int maxChildBlockPercentage) {
        this.maxChildBlockPercentage = maxChildBlockPercentage;
    }

    public void setIgnoreBlockLinesCount(int ignoreBlockLinesCount) {
        this.ignoreBlockLinesCount = ignoreBlockLinesCount;
    }

    public int[] getDefaultTokens() {
        int[] result = this.blockTypes == null ? null : Arrays.copyOf(this.blockTypes, this.blockTypes.length);
        return result;
    }

    public int[] getAcceptableTokens() {
        return this.getDefaultTokens();
    }

    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    public void visitToken(DetailAST ast) {
        block4: {
            DetailAST aClosingBrace;
            int parentBlockSize;
            DetailAST aOpeningBrace = ChildBlockLengthCheck.openingBrace(ast);
            if (aOpeningBrace == null || (parentBlockSize = ChildBlockLengthCheck.linesCount(aOpeningBrace, aClosingBrace = ChildBlockLengthCheck.closingBrace(ast))) <= this.ignoreBlockLinesCount) break block4;
            List<DetailAST> childBlocks = this.getChildBlocks(aOpeningBrace, aClosingBrace);
            List<DetailAST> badChildBlocks = this.getBadChildBlocks(childBlocks, parentBlockSize);
            if (badChildBlocks.isEmpty()) {
                for (DetailAST childBlock : childBlocks) {
                    this.visitToken(childBlock);
                }
            } else {
                for (DetailAST badBlock : badChildBlocks) {
                    int blockSize = ChildBlockLengthCheck.linesCount(badBlock);
                    double allowedBlockSize = (int)((double)parentBlockSize * this.maxChildBlockPercentage / 100.0);
                    this.log(badBlock, MSG_KEY, new Object[]{blockSize, allowedBlockSize});
                }
            }
        }
    }

    private List<DetailAST> getChildBlocks(DetailAST blockOpeningBrace, DetailAST blockClosingBrace) {
        LinkedList<DetailAST> childBlocks = new LinkedList<DetailAST>();
        DetailAST curNode = blockOpeningBrace;
        while (curNode != blockClosingBrace) {
            if (this.isAllowedBlockType(curNode.getType())) {
                childBlocks.add(curNode);
            }
            DetailAST nextNode = curNode.getFirstChild();
            int type = curNode.getType();
            if (type == 9 || type == 14) {
                nextNode = curNode.getNextSibling();
            }
            while (nextNode == null) {
                nextNode = curNode.getNextSibling();
                if (nextNode != null) continue;
                curNode = curNode.getParent();
            }
            curNode = nextNode;
        }
        return childBlocks;
    }

    private boolean isAllowedBlockType(int blockType) {
        boolean result = false;
        for (int type : this.blockTypes) {
            if (type != blockType) continue;
            result = true;
            break;
        }
        return result;
    }

    private List<DetailAST> getBadChildBlocks(List<DetailAST> blocksList, int parentBlockSize) {
        LinkedList<DetailAST> result = new LinkedList<DetailAST>();
        for (DetailAST block : blocksList) {
            if (!this.isChildBlockBad(block, parentBlockSize)) continue;
            result.add(block);
        }
        return result;
    }

    private boolean isChildBlockBad(DetailAST childBlock, int parentBlockSize) {
        boolean result = false;
        DetailAST openingBrace = ChildBlockLengthCheck.openingBrace(childBlock);
        if (openingBrace != null) {
            DetailAST closingBrace = ChildBlockLengthCheck.closingBrace(childBlock);
            int childBlockSize = ChildBlockLengthCheck.linesCount(openingBrace, closingBrace);
            result = this.getPercentage(parentBlockSize, childBlockSize);
        }
        return result;
    }

    private boolean getPercentage(int parentBlockSize, int childBlockSize) {
        double percentage = (double)childBlockSize / (double)parentBlockSize * 100.0;
        return percentage > this.maxChildBlockPercentage;
    }

    private static DetailAST openingBrace(DetailAST parentBlock) {
        int searchType = parentBlock.getType() == 89 ? 72 : 7;
        return parentBlock.findFirstToken(searchType);
    }

    private static DetailAST closingBrace(DetailAST parentBlockNode) {
        int aParentBlockType = parentBlockNode.getType();
        DetailAST result = aParentBlockType == 89 ? parentBlockNode.getLastChild() : ChildBlockLengthCheck.openingBrace(parentBlockNode).getLastChild();
        return result;
    }

    private static int linesCount(DetailAST blockAst) {
        return ChildBlockLengthCheck.linesCount(ChildBlockLengthCheck.openingBrace(blockAst), ChildBlockLengthCheck.closingBrace(blockAst));
    }

    private static int linesCount(DetailAST openingBrace, DetailAST closingBrace) {
        int result = closingBrace.getLineNo() - openingBrace.getLineNo();
        if (result != 0) {
            --result;
        }
        return result;
    }
}

