/*
 * Decompiled with CFR 0.152.
 */
package com.power.common.util;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;

public class ApiSignUtil {
    public static Map<String, Object> sign(String appID, String SECRET, String nonceStr) {
        HashMap<String, Object> ret = new HashMap<String, Object>(4);
        long timestamp = System.currentTimeMillis() / 1000L;
        String signature = ApiSignUtil.getSignature(appID, SECRET, nonceStr, timestamp);
        ret.put("nonceStr", nonceStr);
        ret.put("timestamp", timestamp);
        ret.put("signature", signature);
        ret.put("appId", appID);
        return ret;
    }

    public static String getSignature(String appID, String SECRET, String nonceStr, long timestamp) {
        String signature = "";
        String string1 = "app_id=" + appID + "&app_key" + SECRET + "&noncestr=" + nonceStr + "&timestamp=" + timestamp;
        try {
            MessageDigest crypt = MessageDigest.getInstance("SHA-1");
            crypt.reset();
            crypt.update(string1.getBytes(StandardCharsets.UTF_8));
            signature = ApiSignUtil.byteToHex(crypt.digest());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return signature;
    }

    private static String byteToHex(byte[] hash) {
        Formatter formatter = new Formatter();
        for (byte b : hash) {
            formatter.format("%02x", b);
        }
        String result = formatter.toString();
        formatter.close();
        return result;
    }
}

