/*
 * Decompiled with CFR 0.152.
 */
package com.smartdoc.gradle.plugin;

import com.smartdoc.gradle.constant.TaskConstants;
import com.smartdoc.gradle.extension.SmartDocPluginExtension;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.plugins.JavaPlugin;

public class SmartDocPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getPluginManager().apply(JavaPlugin.class);
        Task javaCompileTask = project.getTasks().getByName("compileJava");
        TaskConstants.taskMap.forEach((taskName, taskClass) -> this.createTask(project, (String)taskName, (Class)taskClass, javaCompileTask));
        project.getExtensions().create("smartdoc", SmartDocPluginExtension.class, new Object[0]);
    }

    private <T extends Task> void createTask(Project project, String taskName, Class<T> taskClass, Task javaCompileTask) {
        Task t = project.getTasks().create(taskName, taskClass);
        t.setGroup("Documentation");
        t.dependsOn(new Object[]{javaCompileTask});
    }
}

