/*
 * Decompiled with CFR 0.152.
 */
package com.smartdoc.gradle.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;

public class ClassLoaderUtil {
    public static ClassLoader getRuntimeClassLoader(Project project) {
        try {
            Configuration compileConfiguration = project.getConfigurations().getByName("compileClasspath");
            Set fileSet = compileConfiguration.getFiles();
            ArrayList<URL> urls = new ArrayList<URL>();
            for (File file : fileSet) {
                urls.add(file.toURI().toURL());
            }
            SourceSetContainer ssc = ((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets();
            FileCollection classesDir = ((SourceSet)ssc.getByName("main")).getOutput().getClassesDirs();
            Set fileSet1 = classesDir.getFiles();
            for (File file : fileSet1) {
                urls.add(file.toURI().toURL());
            }
            URL[] runtimeUrls = urls.toArray(new URL[0]);
            return new URLClassLoader(runtimeUrls, Thread.currentThread().getContextClassLoader());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Unable to load project runtime !", e);
        }
    }
}

