/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.builder;

import com.power.common.util.CollectionUtil;
import com.power.common.util.StringUtil;
import com.power.doc.constants.DocGlobalConstants;
import com.power.doc.constants.HighlightStyle;
import com.power.doc.helper.JavaProjectBuilderHelper;
import com.power.doc.model.ApiConfig;
import com.power.doc.model.ApiConstant;
import com.power.doc.model.ApiDataDictionary;
import com.power.doc.model.ApiErrorCodeDictionary;
import com.power.doc.model.ApiObjectReplacement;
import com.power.doc.model.BodyAdvice;
import com.power.doc.model.CustomField;
import com.power.doc.model.DocJavaField;
import com.power.doc.model.SourceCodePath;
import com.power.doc.utils.JavaClassUtil;
import com.thoughtworks.qdox.JavaProjectBuilder;
import com.thoughtworks.qdox.directorywalker.DirectoryScanner;
import com.thoughtworks.qdox.directorywalker.Filter;
import com.thoughtworks.qdox.directorywalker.SuffixFilter;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.parser.ParseException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;

public class ProjectDocConfigBuilder {
    private static final Logger log = Logger.getLogger(ProjectDocConfigBuilder.class.getName());
    private final JavaProjectBuilder javaProjectBuilder;
    private final Map<String, JavaClass> classFilesMap = new ConcurrentHashMap<String, JavaClass>();
    private final Map<String, Class<? extends Enum>> enumClassMap = new ConcurrentHashMap<String, Class<? extends Enum>>();
    private final Map<String, CustomField> customRespFieldMap = new ConcurrentHashMap<String, CustomField>();
    private final Map<String, CustomField> customReqFieldMap = new ConcurrentHashMap<String, CustomField>();
    private final Map<String, String> replaceClassMap = new ConcurrentHashMap<String, String>();
    private final Map<String, String> constantsMap = new ConcurrentHashMap<String, String>();
    private final String serverUrl;
    private final ApiConfig apiConfig;

    public ProjectDocConfigBuilder(ApiConfig apiConfig, JavaProjectBuilder javaProjectBuilder) {
        if (null == apiConfig) {
            throw new NullPointerException("ApiConfig can't be null.");
        }
        this.apiConfig = apiConfig;
        if (Objects.isNull(javaProjectBuilder)) {
            javaProjectBuilder = JavaProjectBuilderHelper.create();
        }
        this.serverUrl = StringUtil.isEmpty((String)apiConfig.getServerUrl()) ? "" : apiConfig.getServerUrl();
        this.setHighlightStyle();
        javaProjectBuilder.setEncoding("utf-8");
        this.javaProjectBuilder = javaProjectBuilder;
        try {
            this.loadJavaSource(apiConfig.getSourceCodePaths(), this.javaProjectBuilder);
        }
        catch (Exception e) {
            log.warning(e.getMessage());
        }
        this.initClassFilesMap();
        this.initCustomResponseFieldsMap(apiConfig);
        this.initCustomRequestFieldsMap(apiConfig);
        this.initReplaceClassMap(apiConfig);
        this.initConstants(apiConfig);
        this.initDict(apiConfig);
        this.checkBodyAdvice(apiConfig.getRequestBodyAdvice());
        this.checkBodyAdvice(apiConfig.getResponseBodyAdvice());
    }

    private void initDict(ApiConfig apiConfig) {
        if (this.enumClassMap.size() == 0) {
            return;
        }
        List<ApiDataDictionary> dataDictionaries = apiConfig.getDataDictionaries();
        if (Objects.isNull(dataDictionaries)) {
            dataDictionaries = new ArrayList<ApiDataDictionary>();
        }
        for (ApiDataDictionary dataDictionary : dataDictionaries) {
            dataDictionary.setEnumImplementSet(this.getEnumImplementsByInterface(dataDictionary.getEnumClass()));
        }
        List<ApiErrorCodeDictionary> errorCodeDictionaries = apiConfig.getErrorCodeDictionaries();
        if (Objects.isNull(errorCodeDictionaries)) {
            errorCodeDictionaries = new ArrayList<ApiErrorCodeDictionary>();
        }
        for (ApiErrorCodeDictionary errorCodeDictionary : errorCodeDictionaries) {
            errorCodeDictionary.setEnumImplementSet(this.getEnumImplementsByInterface(errorCodeDictionary.getEnumClass()));
        }
    }

    private Set<Class<? extends Enum>> getEnumImplementsByInterface(Class<?> enumClass) {
        if (!enumClass.isInterface()) {
            return Collections.emptySet();
        }
        HashSet<Class<? extends Enum>> set = new HashSet<Class<? extends Enum>>();
        this.enumClassMap.forEach((k, v) -> {
            if (enumClass.isAssignableFrom((Class<?>)v)) {
                set.add((Class<? extends Enum>)v);
            }
        });
        return set;
    }

    public JavaClass getClassByName(String simpleName) {
        JavaClass cls = this.javaProjectBuilder.getClassByName(simpleName);
        List<DocJavaField> fieldList = JavaClassUtil.getFields(cls, 0, new LinkedHashMap<String, DocJavaField>());
        if (Objects.isNull(cls.getFields()) || fieldList.isEmpty()) {
            cls = this.classFilesMap.get(simpleName);
        } else {
            List classList = cls.getNestedClasses();
            for (JavaClass javaClass : classList) {
                this.classFilesMap.put(javaClass.getFullyQualifiedName(), javaClass);
            }
        }
        return cls;
    }

    private void loadJavaSource(List<SourceCodePath> paths, JavaProjectBuilder builder) {
        if (CollectionUtil.isEmpty(paths)) {
            builder.addSourceTree(new File(DocGlobalConstants.PROJECT_CODE_PATH));
        } else {
            for (SourceCodePath path : paths) {
                String strPath;
                if (null == path || !StringUtil.isNotEmpty((String)(strPath = path.getPath()))) continue;
                strPath = strPath.replace("\\", "/");
                this.loadJavaSource(strPath, builder);
            }
        }
    }

    private void loadJavaSource(String strPath, JavaProjectBuilder builder) {
        DirectoryScanner scanner = new DirectoryScanner(new File(strPath));
        scanner.addFilter((Filter)new SuffixFilter(".java"));
        scanner.scan(currentFile -> {
            try {
                builder.addSource(currentFile);
            }
            catch (ParseException | IOException e) {
                log.warning(e.getMessage());
            }
        });
    }

    private void initClassFilesMap() {
        Collection javaClasses = this.javaProjectBuilder.getClasses();
        for (JavaClass cls : javaClasses) {
            if (cls.isEnum()) {
                ClassLoader classLoader = this.apiConfig.getClassLoader();
                try {
                    Class<?> enumClass = Objects.isNull(classLoader) ? Class.forName(cls.getFullyQualifiedName()) : classLoader.loadClass(cls.getFullyQualifiedName());
                    this.enumClassMap.put(cls.getFullyQualifiedName(), enumClass);
                }
                catch (ClassNotFoundException e) {
                    continue;
                }
            }
            this.classFilesMap.put(cls.getFullyQualifiedName(), cls);
        }
    }

    private void initCustomResponseFieldsMap(ApiConfig config) {
        if (CollectionUtil.isNotEmpty(config.getCustomResponseFields())) {
            for (CustomField field : config.getCustomResponseFields()) {
                this.customRespFieldMap.put(field.getOwnerClassName() + "." + field.getName(), field);
            }
        }
    }

    private void initCustomRequestFieldsMap(ApiConfig config) {
        if (CollectionUtil.isNotEmpty(config.getCustomRequestFields())) {
            for (CustomField field : config.getCustomRequestFields()) {
                this.customReqFieldMap.put(field.getOwnerClassName() + "." + field.getName(), field);
            }
        }
    }

    private void initReplaceClassMap(ApiConfig config) {
        if (CollectionUtil.isNotEmpty(config.getApiObjectReplacements())) {
            for (ApiObjectReplacement replace : config.getApiObjectReplacements()) {
                this.replaceClassMap.put(replace.getClassName(), replace.getReplacementClassName());
            }
        }
    }

    private void initConstants(ApiConfig config) {
        List<ApiConstant> apiConstants = CollectionUtil.isEmpty(config.getApiConstants()) ? new ArrayList<ApiConstant>() : config.getApiConstants();
        try {
            for (ApiConstant apiConstant : apiConstants) {
                Class<?> clzz = apiConstant.getConstantsClass();
                if (Objects.isNull(clzz)) {
                    if (StringUtil.isEmpty((String)apiConstant.getConstantsClassName())) {
                        throw new RuntimeException("Enum class name can't be null.");
                    }
                    clzz = Class.forName(apiConstant.getConstantsClassName());
                }
                this.constantsMap.putAll(JavaClassUtil.getFinalFieldValue(clzz));
            }
        }
        catch (ClassNotFoundException | IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private void checkBodyAdvice(BodyAdvice bodyAdvice) {
        if (Objects.nonNull(bodyAdvice) && StringUtil.isNotEmpty((String)bodyAdvice.getClassName())) {
            if (Objects.nonNull(bodyAdvice.getWrapperClass())) {
                return;
            }
            try {
                Class.forName(bodyAdvice.getClassName());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Can't find class " + bodyAdvice.getClassName() + " for ResponseBodyAdvice.");
            }
        }
    }

    private void setHighlightStyle() {
        String style = this.apiConfig.getStyle();
        if ("xt256".equals(style)) {
            this.apiConfig.setHighlightStyleLink("xt256.min.css");
            return;
        }
        if (HighlightStyle.containsStyle(style)) {
            this.apiConfig.setHighlightStyleLink(String.format("https://cdn.bootcdn.net/ajax/libs/highlight.js/10.3.2/styles/%s.min.css", style));
            return;
        }
        Random random = new Random();
        if ("randomLight".equals(style)) {
            style = HighlightStyle.randomLight(random);
            if (HighlightStyle.containsStyle(style)) {
                this.apiConfig.setStyle(style);
                this.apiConfig.setHighlightStyleLink(String.format("https://cdn.bootcdn.net/ajax/libs/highlight.js/10.3.2/styles/%s.min.css", style));
            } else {
                this.apiConfig.setStyle(null);
            }
        } else if ("randomDark".equals(style)) {
            style = HighlightStyle.randomDark(random);
            if ("xt256".equals(style)) {
                this.apiConfig.setHighlightStyleLink("xt256.min.css");
            } else {
                this.apiConfig.setHighlightStyleLink(String.format("https://cdn.bootcdn.net/ajax/libs/highlight.js/10.3.2/styles/%s.min.css", style));
            }
            this.apiConfig.setStyle(style);
        } else {
            this.apiConfig.setStyle(null);
        }
    }

    public JavaProjectBuilder getJavaProjectBuilder() {
        return this.javaProjectBuilder;
    }

    public Map<String, JavaClass> getClassFilesMap() {
        return this.classFilesMap;
    }

    public Map<String, CustomField> getCustomRespFieldMap() {
        return this.customRespFieldMap;
    }

    public Map<String, CustomField> getCustomReqFieldMap() {
        return this.customReqFieldMap;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public ApiConfig getApiConfig() {
        return this.apiConfig;
    }

    public Map<String, String> getReplaceClassMap() {
        return this.replaceClassMap;
    }

    public Map<String, Class<? extends Enum>> getEnumClassMap() {
        return this.enumClassMap;
    }

    public Map<String, String> getConstantsMap() {
        return this.constantsMap;
    }
}

